/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.WebChatSettings;
import java.util.HashMap;
import java.util.Map;

public class PostWebchatSettingsRequest {
    private WebChatSettings body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public WebChatSettings getBody() {
        return this.body;
    }

    public void setBody(WebChatSettings body) {
        this.body = body;
    }

    public PostWebchatSettingsRequest withBody(WebChatSettings body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostWebchatSettingsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<WebChatSettings> withHttpInfo() {
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostWebchatSettingsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/webchat/settings").withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WebChatSettings body) {
        return new Builder().withRequiredParams(body);
    }

    public static class Builder {
        private final PostWebchatSettingsRequest request = new PostWebchatSettingsRequest();

        private Builder() {
        }

        public Builder withBody(WebChatSettings body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(WebChatSettings body) {
            this.request.setBody(body);
            return this;
        }

        public PostWebchatSettingsRequest build() {
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostWebchatSettingsRequest.");
            }
            return this.request;
        }
    }
}

