/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.CallHistoryParticipant;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CallHistoryConversation
implements Serializable {
    private String id = null;
    private String name = null;
    private List<CallHistoryParticipant> participants = new ArrayList<CallHistoryParticipant>();
    private DirectionEnum direction = null;
    private Boolean wentToVoicemail = null;
    private Boolean missedCall = null;
    private Date startTime = null;
    private Boolean wasConference = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public CallHistoryConversation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CallHistoryConversation participants(List<CallHistoryParticipant> participants) {
        this.participants = participants;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of participants involved in the conversation.")
    @JsonProperty(value="participants")
    public List<CallHistoryParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<CallHistoryParticipant> participants) {
        this.participants = participants;
    }

    public CallHistoryConversation direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The direction of the call relating to the current user")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public CallHistoryConversation wentToVoicemail(Boolean wentToVoicemail) {
        this.wentToVoicemail = wentToVoicemail;
        return this;
    }

    @ApiModelProperty(example="null", value="Did the call end in the current user's voicemail")
    @JsonProperty(value="wentToVoicemail")
    public Boolean getWentToVoicemail() {
        return this.wentToVoicemail;
    }

    public void setWentToVoicemail(Boolean wentToVoicemail) {
        this.wentToVoicemail = wentToVoicemail;
    }

    public CallHistoryConversation missedCall(Boolean missedCall) {
        this.missedCall = missedCall;
        return this;
    }

    @ApiModelProperty(example="null", value="Did the user not answer this conversation")
    @JsonProperty(value="missedCall")
    public Boolean getMissedCall() {
        return this.missedCall;
    }

    public void setMissedCall(Boolean missedCall) {
        this.missedCall = missedCall;
    }

    public CallHistoryConversation startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time the user joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startTime")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public CallHistoryConversation wasConference(Boolean wasConference) {
        this.wasConference = wasConference;
        return this;
    }

    @ApiModelProperty(example="null", value="Was this conversation a conference")
    @JsonProperty(value="wasConference")
    public Boolean getWasConference() {
        return this.wasConference;
    }

    public void setWasConference(Boolean wasConference) {
        this.wasConference = wasConference;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallHistoryConversation callHistoryConversation = (CallHistoryConversation)o;
        return Objects.equals(this.id, callHistoryConversation.id) && Objects.equals(this.name, callHistoryConversation.name) && Objects.equals(this.participants, callHistoryConversation.participants) && Objects.equals((Object)this.direction, (Object)callHistoryConversation.direction) && Objects.equals(this.wentToVoicemail, callHistoryConversation.wentToVoicemail) && Objects.equals(this.missedCall, callHistoryConversation.missedCall) && Objects.equals(this.startTime, callHistoryConversation.startTime) && Objects.equals(this.wasConference, callHistoryConversation.wasConference) && Objects.equals(this.selfUri, callHistoryConversation.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.participants, this.direction, this.wentToVoicemail, this.missedCall, this.startTime, this.wasConference, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CallHistoryConversation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    wentToVoicemail: ").append(this.toIndentedString(this.wentToVoicemail)).append("\n");
        sb.append("    missedCall: ").append(this.toIndentedString(this.missedCall)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    wasConference: ").append(this.toIndentedString(this.wasConference)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

