/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.Group;
import com.mypurecloud.sdk.v2.model.SecurityProfile;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class WorkspaceMember
implements Serializable {
    private String id = null;
    private String name = null;
    private DomainEntityRef workspace = null;
    private MemberTypeEnum memberType = null;
    private DomainEntityRef member = null;
    private User user = null;
    private Group group = null;
    private SecurityProfile securityProfile = null;
    private String selfUri = null;

    public WorkspaceMember() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WorkspaceMember name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkspaceMember workspace(DomainEntityRef workspace) {
        this.workspace = workspace;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="workspace")
    public DomainEntityRef getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(DomainEntityRef workspace) {
        this.workspace = workspace;
    }

    public WorkspaceMember memberType(MemberTypeEnum memberType) {
        this.memberType = memberType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The workspace member type.")
    @JsonProperty(value="memberType")
    public MemberTypeEnum getMemberType() {
        return this.memberType;
    }

    public void setMemberType(MemberTypeEnum memberType) {
        this.memberType = memberType;
    }

    public WorkspaceMember member(DomainEntityRef member) {
        this.member = member;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="member")
    public DomainEntityRef getMember() {
        return this.member;
    }

    public void setMember(DomainEntityRef member) {
        this.member = member;
    }

    public WorkspaceMember user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="user")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public WorkspaceMember group(Group group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="group")
    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public WorkspaceMember securityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="securityProfile")
    public SecurityProfile getSecurityProfile() {
        return this.securityProfile;
    }

    public void setSecurityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkspaceMember workspaceMember = (WorkspaceMember)o;
        return Objects.equals(this.id, workspaceMember.id) && Objects.equals(this.name, workspaceMember.name) && Objects.equals(this.workspace, workspaceMember.workspace) && Objects.equals((Object)this.memberType, (Object)workspaceMember.memberType) && Objects.equals(this.member, workspaceMember.member) && Objects.equals(this.user, workspaceMember.user) && Objects.equals(this.group, workspaceMember.group) && Objects.equals(this.securityProfile, workspaceMember.securityProfile) && Objects.equals(this.selfUri, workspaceMember.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.workspace, this.memberType, this.member, this.user, this.group, this.securityProfile, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkspaceMember {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    workspace: ").append(this.toIndentedString(this.workspace)).append("\n");
        sb.append("    memberType: ").append(this.toIndentedString((Object)this.memberType)).append("\n");
        sb.append("    member: ").append(this.toIndentedString(this.member)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    securityProfile: ").append(this.toIndentedString(this.securityProfile)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MemberTypeEnumDeserializer.class)
    public static enum MemberTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        USER("USER"),
        GROUP("GROUP");

        private String value;

        private MemberTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MemberTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MemberTypeEnum value : MemberTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MemberTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MemberTypeEnumDeserializer
    extends StdDeserializer<MemberTypeEnum> {
        public MemberTypeEnumDeserializer() {
            super(MemberTypeEnumDeserializer.class);
        }

        public MemberTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MemberTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

