/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class WorkitemOnAttributeChangeCondition
implements Serializable {
    private AttributeEnum attribute = null;
    private String newValue = null;
    private String oldValue = null;

    public WorkitemOnAttributeChangeCondition() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public WorkitemOnAttributeChangeCondition attribute(AttributeEnum attribute) {
        this.attribute = attribute;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the workitem attribute whose change will be evaluated as part of the rule.")
    @JsonProperty(value="attribute")
    public AttributeEnum getAttribute() {
        return this.attribute;
    }

    public void setAttribute(AttributeEnum attribute) {
        this.attribute = attribute;
    }

    public WorkitemOnAttributeChangeCondition newValue(String newValue) {
        this.newValue = newValue;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The new value of the attribute. If the attribute is updated to this value this part of the condition will be met.")
    @JsonProperty(value="newValue")
    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public WorkitemOnAttributeChangeCondition oldValue(String oldValue) {
        this.oldValue = oldValue;
        return this;
    }

    @ApiModelProperty(example="null", value="The old value of the attribute. If the attribute was updated from this value this part of the condition will be met.")
    @JsonProperty(value="oldValue")
    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkitemOnAttributeChangeCondition workitemOnAttributeChangeCondition = (WorkitemOnAttributeChangeCondition)o;
        return Objects.equals((Object)this.attribute, (Object)workitemOnAttributeChangeCondition.attribute) && Objects.equals(this.newValue, workitemOnAttributeChangeCondition.newValue) && Objects.equals(this.oldValue, workitemOnAttributeChangeCondition.oldValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attribute, this.newValue, this.oldValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkitemOnAttributeChangeCondition {\n");
        sb.append("    attribute: ").append(this.toIndentedString((Object)this.attribute)).append("\n");
        sb.append("    newValue: ").append(this.toIndentedString(this.newValue)).append("\n");
        sb.append("    oldValue: ").append(this.toIndentedString(this.oldValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AttributeEnumDeserializer.class)
    public static enum AttributeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STATUSID("statusId");

        private String value;

        private AttributeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AttributeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AttributeEnum value : AttributeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AttributeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AttributeEnumDeserializer
    extends StdDeserializer<AttributeEnum> {
        public AttributeEnumDeserializer() {
            super(AttributeEnumDeserializer.class);
        }

        public AttributeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AttributeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

