/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AgentAdherenceDayMetrics;
import com.mypurecloud.sdk.v2.model.AgentAdherenceScheduledActivity;
import com.mypurecloud.sdk.v2.model.HistoricalAdherenceActuals;
import com.mypurecloud.sdk.v2.model.HistoricalAdherenceExceptionInfo;
import com.mypurecloud.sdk.v2.model.SecondaryPresenceLookupItem;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class WfmAgentHistoricalAdherenceResult
implements Serializable {
    private UserReference user = null;
    private Date startDate = null;
    private Date endDate = null;
    private Date calculationsCompletedDate = null;
    private Double targetAdherencePercentage = null;
    private Double adherencePercentage = null;
    private Double conformancePercentage = null;
    private ImpactEnum impact = null;
    private List<HistoricalAdherenceExceptionInfo> exceptionInfo = null;
    private List<AgentAdherenceDayMetrics> dayMetrics = null;
    private List<HistoricalAdherenceActuals> actuals = null;
    private List<AgentAdherenceScheduledActivity> scheduledActivities = null;
    private List<SecondaryPresenceLookupItem> secondaryPresenceLookupItems = null;

    public WfmAgentHistoricalAdherenceResult() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.exceptionInfo = new ArrayList<HistoricalAdherenceExceptionInfo>();
            this.dayMetrics = new ArrayList<AgentAdherenceDayMetrics>();
            this.actuals = new ArrayList<HistoricalAdherenceActuals>();
            this.scheduledActivities = new ArrayList<AgentAdherenceScheduledActivity>();
            this.secondaryPresenceLookupItems = new ArrayList<SecondaryPresenceLookupItem>();
        }
    }

    public WfmAgentHistoricalAdherenceResult user(UserReference user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who submitted the agent historical adherence query")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    public void setUser(UserReference user) {
        this.user = user;
    }

    public WfmAgentHistoricalAdherenceResult startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Beginning of the date range that was queried, in ISO-8601 format")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public WfmAgentHistoricalAdherenceResult endDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="End of the date range that was queried, in ISO-8601 format. If it was not set, end date will be set to the queried time")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public WfmAgentHistoricalAdherenceResult calculationsCompletedDate(Date calculationsCompletedDate) {
        this.calculationsCompletedDate = calculationsCompletedDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Completed date of calculations that was queried, in ISO-8601 format.")
    @JsonProperty(value="calculationsCompletedDate")
    public Date getCalculationsCompletedDate() {
        return this.calculationsCompletedDate;
    }

    public void setCalculationsCompletedDate(Date calculationsCompletedDate) {
        this.calculationsCompletedDate = calculationsCompletedDate;
    }

    public WfmAgentHistoricalAdherenceResult targetAdherencePercentage(Double targetAdherencePercentage) {
        this.targetAdherencePercentage = targetAdherencePercentage;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Target percentage for this user, in the scale of 0 - 100")
    @JsonProperty(value="targetAdherencePercentage")
    public Double getTargetAdherencePercentage() {
        return this.targetAdherencePercentage;
    }

    public void setTargetAdherencePercentage(Double targetAdherencePercentage) {
        this.targetAdherencePercentage = targetAdherencePercentage;
    }

    public WfmAgentHistoricalAdherenceResult adherencePercentage(Double adherencePercentage) {
        this.adherencePercentage = adherencePercentage;
        return this;
    }

    @ApiModelProperty(example="null", value="Adherence percentage for this user, in the scale of 0 - 100")
    @JsonProperty(value="adherencePercentage")
    public Double getAdherencePercentage() {
        return this.adherencePercentage;
    }

    public void setAdherencePercentage(Double adherencePercentage) {
        this.adherencePercentage = adherencePercentage;
    }

    public WfmAgentHistoricalAdherenceResult conformancePercentage(Double conformancePercentage) {
        this.conformancePercentage = conformancePercentage;
        return this;
    }

    @ApiModelProperty(example="null", value="Conformance percentage for this user, in the scale of 0 - 100. Conformance percentage can be greater than 100 when the actual on queue time is greater than the scheduled on queue time for the same period.")
    @JsonProperty(value="conformancePercentage")
    public Double getConformancePercentage() {
        return this.conformancePercentage;
    }

    public void setConformancePercentage(Double conformancePercentage) {
        this.conformancePercentage = conformancePercentage;
    }

    public WfmAgentHistoricalAdherenceResult impact(ImpactEnum impact) {
        this.impact = impact;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The impact of the current adherence state for this user")
    @JsonProperty(value="impact")
    public ImpactEnum getImpact() {
        return this.impact;
    }

    public void setImpact(ImpactEnum impact) {
        this.impact = impact;
    }

    public WfmAgentHistoricalAdherenceResult exceptionInfo(List<HistoricalAdherenceExceptionInfo> exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="List of adherence exceptions for this user")
    @JsonProperty(value="exceptionInfo")
    public List<HistoricalAdherenceExceptionInfo> getExceptionInfo() {
        return this.exceptionInfo;
    }

    public void setExceptionInfo(List<HistoricalAdherenceExceptionInfo> exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    public WfmAgentHistoricalAdherenceResult dayMetrics(List<AgentAdherenceDayMetrics> dayMetrics) {
        this.dayMetrics = dayMetrics;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Adherence and conformance metrics for days in query range")
    @JsonProperty(value="dayMetrics")
    public List<AgentAdherenceDayMetrics> getDayMetrics() {
        return this.dayMetrics;
    }

    public void setDayMetrics(List<AgentAdherenceDayMetrics> dayMetrics) {
        this.dayMetrics = dayMetrics;
    }

    public WfmAgentHistoricalAdherenceResult actuals(List<HistoricalAdherenceActuals> actuals) {
        this.actuals = actuals;
        return this;
    }

    @ApiModelProperty(example="null", value="List of actual activity with offset for this user")
    @JsonProperty(value="actuals")
    public List<HistoricalAdherenceActuals> getActuals() {
        return this.actuals;
    }

    public void setActuals(List<HistoricalAdherenceActuals> actuals) {
        this.actuals = actuals;
    }

    public WfmAgentHistoricalAdherenceResult scheduledActivities(List<AgentAdherenceScheduledActivity> scheduledActivities) {
        this.scheduledActivities = scheduledActivities;
        return this;
    }

    @ApiModelProperty(example="null", value="List of scheduled activities for this user")
    @JsonProperty(value="scheduledActivities")
    public List<AgentAdherenceScheduledActivity> getScheduledActivities() {
        return this.scheduledActivities;
    }

    public void setScheduledActivities(List<AgentAdherenceScheduledActivity> scheduledActivities) {
        this.scheduledActivities = scheduledActivities;
    }

    public WfmAgentHistoricalAdherenceResult secondaryPresenceLookupItems(List<SecondaryPresenceLookupItem> secondaryPresenceLookupItems) {
        this.secondaryPresenceLookupItems = secondaryPresenceLookupItems;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="List of secondary presence lookup ID to corresponding secondary presence ID item")
    @JsonProperty(value="secondaryPresenceLookupItems")
    public List<SecondaryPresenceLookupItem> getSecondaryPresenceLookupItems() {
        return this.secondaryPresenceLookupItems;
    }

    public void setSecondaryPresenceLookupItems(List<SecondaryPresenceLookupItem> secondaryPresenceLookupItems) {
        this.secondaryPresenceLookupItems = secondaryPresenceLookupItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WfmAgentHistoricalAdherenceResult wfmAgentHistoricalAdherenceResult = (WfmAgentHistoricalAdherenceResult)o;
        return Objects.equals(this.user, wfmAgentHistoricalAdherenceResult.user) && Objects.equals(this.startDate, wfmAgentHistoricalAdherenceResult.startDate) && Objects.equals(this.endDate, wfmAgentHistoricalAdherenceResult.endDate) && Objects.equals(this.calculationsCompletedDate, wfmAgentHistoricalAdherenceResult.calculationsCompletedDate) && Objects.equals(this.targetAdherencePercentage, wfmAgentHistoricalAdherenceResult.targetAdherencePercentage) && Objects.equals(this.adherencePercentage, wfmAgentHistoricalAdherenceResult.adherencePercentage) && Objects.equals(this.conformancePercentage, wfmAgentHistoricalAdherenceResult.conformancePercentage) && Objects.equals((Object)this.impact, (Object)wfmAgentHistoricalAdherenceResult.impact) && Objects.equals(this.exceptionInfo, wfmAgentHistoricalAdherenceResult.exceptionInfo) && Objects.equals(this.dayMetrics, wfmAgentHistoricalAdherenceResult.dayMetrics) && Objects.equals(this.actuals, wfmAgentHistoricalAdherenceResult.actuals) && Objects.equals(this.scheduledActivities, wfmAgentHistoricalAdherenceResult.scheduledActivities) && Objects.equals(this.secondaryPresenceLookupItems, wfmAgentHistoricalAdherenceResult.secondaryPresenceLookupItems);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.user, this.startDate, this.endDate, this.calculationsCompletedDate, this.targetAdherencePercentage, this.adherencePercentage, this.conformancePercentage, this.impact, this.exceptionInfo, this.dayMetrics, this.actuals, this.scheduledActivities, this.secondaryPresenceLookupItems});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WfmAgentHistoricalAdherenceResult {\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    calculationsCompletedDate: ").append(this.toIndentedString(this.calculationsCompletedDate)).append("\n");
        sb.append("    targetAdherencePercentage: ").append(this.toIndentedString(this.targetAdherencePercentage)).append("\n");
        sb.append("    adherencePercentage: ").append(this.toIndentedString(this.adherencePercentage)).append("\n");
        sb.append("    conformancePercentage: ").append(this.toIndentedString(this.conformancePercentage)).append("\n");
        sb.append("    impact: ").append(this.toIndentedString((Object)this.impact)).append("\n");
        sb.append("    exceptionInfo: ").append(this.toIndentedString(this.exceptionInfo)).append("\n");
        sb.append("    dayMetrics: ").append(this.toIndentedString(this.dayMetrics)).append("\n");
        sb.append("    actuals: ").append(this.toIndentedString(this.actuals)).append("\n");
        sb.append("    scheduledActivities: ").append(this.toIndentedString(this.scheduledActivities)).append("\n");
        sb.append("    secondaryPresenceLookupItems: ").append(this.toIndentedString(this.secondaryPresenceLookupItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ImpactEnumDeserializer.class)
    public static enum ImpactEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        POSITIVE("Positive"),
        NEGATIVE("Negative"),
        NEUTRAL("Neutral"),
        UNKNOWN("Unknown");

        private String value;

        private ImpactEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ImpactEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ImpactEnum value : ImpactEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ImpactEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ImpactEnumDeserializer
    extends StdDeserializer<ImpactEnum> {
        public ImpactEnumDeserializer() {
            super(ImpactEnumDeserializer.class);
        }

        public ImpactEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ImpactEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

