/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.Group;
import com.mypurecloud.sdk.v2.model.GroupEmailPolicy;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class VoicemailGroupPolicy
implements Serializable {
    private String name = null;
    private Group group = null;
    private Boolean enabled = null;
    private Boolean sendEmailNotifications = null;
    private Boolean disableEmailPii = null;
    private Boolean includeEmailTranscriptions = null;
    private String languagePreference = null;
    private GroupEmailPolicy emailPolicy = null;
    private Integer rotateCallsSecs = null;
    private Integer stopRingingAfterRotations = null;
    private String overflowGroupId = null;
    private GroupAlertTypeEnum groupAlertType = null;
    private String interactiveResponsePromptId = null;
    private Boolean interactiveResponseRequired = null;

    public VoicemailGroupPolicy() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public VoicemailGroupPolicy name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="The group associated with the policy")
    @JsonProperty(value="group")
    public Group getGroup() {
        return this.group;
    }

    public VoicemailGroupPolicy enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether voicemail is enabled for the group")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public VoicemailGroupPolicy sendEmailNotifications(Boolean sendEmailNotifications) {
        this.sendEmailNotifications = sendEmailNotifications;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether email notifications are sent to group members when a new voicemail is received")
    @JsonProperty(value="sendEmailNotifications")
    public Boolean getSendEmailNotifications() {
        return this.sendEmailNotifications;
    }

    public void setSendEmailNotifications(Boolean sendEmailNotifications) {
        this.sendEmailNotifications = sendEmailNotifications;
    }

    public VoicemailGroupPolicy disableEmailPii(Boolean disableEmailPii) {
        this.disableEmailPii = disableEmailPii;
        return this;
    }

    @ApiModelProperty(example="null", value="Removes any PII from group emails. This is overridden by the analogous organization configuration value. This is always true if HIPAA is enabled or unknown for an organization.")
    @JsonProperty(value="disableEmailPii")
    public Boolean getDisableEmailPii() {
        return this.disableEmailPii;
    }

    public void setDisableEmailPii(Boolean disableEmailPii) {
        this.disableEmailPii = disableEmailPii;
    }

    public VoicemailGroupPolicy includeEmailTranscriptions(Boolean includeEmailTranscriptions) {
        this.includeEmailTranscriptions = includeEmailTranscriptions;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to include the voicemail transcription in a group notification email")
    @JsonProperty(value="includeEmailTranscriptions")
    public Boolean getIncludeEmailTranscriptions() {
        return this.includeEmailTranscriptions;
    }

    public void setIncludeEmailTranscriptions(Boolean includeEmailTranscriptions) {
        this.includeEmailTranscriptions = includeEmailTranscriptions;
    }

    public VoicemailGroupPolicy languagePreference(String languagePreference) {
        this.languagePreference = languagePreference;
        return this;
    }

    @ApiModelProperty(example="null", value="The language preference for the group.  Used for group voicemail transcription")
    @JsonProperty(value="languagePreference")
    public String getLanguagePreference() {
        return this.languagePreference;
    }

    public void setLanguagePreference(String languagePreference) {
        this.languagePreference = languagePreference;
    }

    public VoicemailGroupPolicy emailPolicy(GroupEmailPolicy emailPolicy) {
        this.emailPolicy = emailPolicy;
        return this;
    }

    @ApiModelProperty(example="null", value="The email policy for the group")
    @JsonProperty(value="emailPolicy")
    public GroupEmailPolicy getEmailPolicy() {
        return this.emailPolicy;
    }

    public void setEmailPolicy(GroupEmailPolicy emailPolicy) {
        this.emailPolicy = emailPolicy;
    }

    public VoicemailGroupPolicy rotateCallsSecs(Integer rotateCallsSecs) {
        this.rotateCallsSecs = rotateCallsSecs;
        return this;
    }

    @ApiModelProperty(example="null", value="How many seconds to ring before rotating to the next member in the group")
    @JsonProperty(value="rotateCallsSecs")
    public Integer getRotateCallsSecs() {
        return this.rotateCallsSecs;
    }

    public void setRotateCallsSecs(Integer rotateCallsSecs) {
        this.rotateCallsSecs = rotateCallsSecs;
    }

    public VoicemailGroupPolicy stopRingingAfterRotations(Integer stopRingingAfterRotations) {
        this.stopRingingAfterRotations = stopRingingAfterRotations;
        return this;
    }

    @ApiModelProperty(example="null", value="How many rotations to go through")
    @JsonProperty(value="stopRingingAfterRotations")
    public Integer getStopRingingAfterRotations() {
        return this.stopRingingAfterRotations;
    }

    public void setStopRingingAfterRotations(Integer stopRingingAfterRotations) {
        this.stopRingingAfterRotations = stopRingingAfterRotations;
    }

    public VoicemailGroupPolicy overflowGroupId(String overflowGroupId) {
        this.overflowGroupId = overflowGroupId;
        return this;
    }

    @ApiModelProperty(example="null", value="A fallback group to contact when all of the members in this group did not answer the call.")
    @JsonProperty(value="overflowGroupId")
    public String getOverflowGroupId() {
        return this.overflowGroupId;
    }

    public void setOverflowGroupId(String overflowGroupId) {
        this.overflowGroupId = overflowGroupId;
    }

    public VoicemailGroupPolicy groupAlertType(GroupAlertTypeEnum groupAlertType) {
        this.groupAlertType = groupAlertType;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies if the members in this group should be contacted randomly, in a specific order, or by round-robin.")
    @JsonProperty(value="groupAlertType")
    public GroupAlertTypeEnum getGroupAlertType() {
        return this.groupAlertType;
    }

    public void setGroupAlertType(GroupAlertTypeEnum groupAlertType) {
        this.groupAlertType = groupAlertType;
    }

    public VoicemailGroupPolicy interactiveResponsePromptId(String interactiveResponsePromptId) {
        this.interactiveResponsePromptId = interactiveResponsePromptId;
        return this;
    }

    @ApiModelProperty(example="null", value="The prompt to use when connecting a user to a Group Ring call")
    @JsonProperty(value="interactiveResponsePromptId")
    public String getInteractiveResponsePromptId() {
        return this.interactiveResponsePromptId;
    }

    public void setInteractiveResponsePromptId(String interactiveResponsePromptId) {
        this.interactiveResponsePromptId = interactiveResponsePromptId;
    }

    public VoicemailGroupPolicy interactiveResponseRequired(Boolean interactiveResponseRequired) {
        this.interactiveResponseRequired = interactiveResponseRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether user should be prompted with a confirmation prompt when connecting to a Group Ring call")
    @JsonProperty(value="interactiveResponseRequired")
    public Boolean getInteractiveResponseRequired() {
        return this.interactiveResponseRequired;
    }

    public void setInteractiveResponseRequired(Boolean interactiveResponseRequired) {
        this.interactiveResponseRequired = interactiveResponseRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoicemailGroupPolicy voicemailGroupPolicy = (VoicemailGroupPolicy)o;
        return Objects.equals(this.name, voicemailGroupPolicy.name) && Objects.equals(this.group, voicemailGroupPolicy.group) && Objects.equals(this.enabled, voicemailGroupPolicy.enabled) && Objects.equals(this.sendEmailNotifications, voicemailGroupPolicy.sendEmailNotifications) && Objects.equals(this.disableEmailPii, voicemailGroupPolicy.disableEmailPii) && Objects.equals(this.includeEmailTranscriptions, voicemailGroupPolicy.includeEmailTranscriptions) && Objects.equals(this.languagePreference, voicemailGroupPolicy.languagePreference) && Objects.equals(this.emailPolicy, voicemailGroupPolicy.emailPolicy) && Objects.equals(this.rotateCallsSecs, voicemailGroupPolicy.rotateCallsSecs) && Objects.equals(this.stopRingingAfterRotations, voicemailGroupPolicy.stopRingingAfterRotations) && Objects.equals(this.overflowGroupId, voicemailGroupPolicy.overflowGroupId) && Objects.equals((Object)this.groupAlertType, (Object)voicemailGroupPolicy.groupAlertType) && Objects.equals(this.interactiveResponsePromptId, voicemailGroupPolicy.interactiveResponsePromptId) && Objects.equals(this.interactiveResponseRequired, voicemailGroupPolicy.interactiveResponseRequired);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.group, this.enabled, this.sendEmailNotifications, this.disableEmailPii, this.includeEmailTranscriptions, this.languagePreference, this.emailPolicy, this.rotateCallsSecs, this.stopRingingAfterRotations, this.overflowGroupId, this.groupAlertType, this.interactiveResponsePromptId, this.interactiveResponseRequired});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VoicemailGroupPolicy {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    sendEmailNotifications: ").append(this.toIndentedString(this.sendEmailNotifications)).append("\n");
        sb.append("    disableEmailPii: ").append(this.toIndentedString(this.disableEmailPii)).append("\n");
        sb.append("    includeEmailTranscriptions: ").append(this.toIndentedString(this.includeEmailTranscriptions)).append("\n");
        sb.append("    languagePreference: ").append(this.toIndentedString(this.languagePreference)).append("\n");
        sb.append("    emailPolicy: ").append(this.toIndentedString(this.emailPolicy)).append("\n");
        sb.append("    rotateCallsSecs: ").append(this.toIndentedString(this.rotateCallsSecs)).append("\n");
        sb.append("    stopRingingAfterRotations: ").append(this.toIndentedString(this.stopRingingAfterRotations)).append("\n");
        sb.append("    overflowGroupId: ").append(this.toIndentedString(this.overflowGroupId)).append("\n");
        sb.append("    groupAlertType: ").append(this.toIndentedString((Object)this.groupAlertType)).append("\n");
        sb.append("    interactiveResponsePromptId: ").append(this.toIndentedString(this.interactiveResponsePromptId)).append("\n");
        sb.append("    interactiveResponseRequired: ").append(this.toIndentedString(this.interactiveResponseRequired)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=GroupAlertTypeEnumDeserializer.class)
    public static enum GroupAlertTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        RANDOM("RANDOM"),
        ROUND_ROBIN("ROUND_ROBIN"),
        SEQUENTIAL("SEQUENTIAL");

        private String value;

        private GroupAlertTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GroupAlertTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GroupAlertTypeEnum value : GroupAlertTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GroupAlertTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GroupAlertTypeEnumDeserializer
    extends StdDeserializer<GroupAlertTypeEnum> {
        public GroupAlertTypeEnumDeserializer() {
            super(GroupAlertTypeEnumDeserializer.class);
        }

        public GroupAlertTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GroupAlertTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

