/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AgentVideoSettings;
import com.mypurecloud.sdk.v2.model.UserVideoSettings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="The settings to enable video chat")
public class VideoSettings
implements Serializable {
    private Boolean enabled = null;
    private AgentVideoSettings agent = null;
    private UserVideoSettings user = null;

    public VideoSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public VideoSettings enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="whether or not video is enabled")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public VideoSettings agent(AgentVideoSettings agent) {
        this.agent = agent;
        return this;
    }

    @ApiModelProperty(example="null", value="Video Settings for agent")
    @JsonProperty(value="agent")
    public AgentVideoSettings getAgent() {
        return this.agent;
    }

    public void setAgent(AgentVideoSettings agent) {
        this.agent = agent;
    }

    public VideoSettings user(UserVideoSettings user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="Video Settings for user")
    @JsonProperty(value="user")
    public UserVideoSettings getUser() {
        return this.user;
    }

    public void setUser(UserVideoSettings user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoSettings videoSettings = (VideoSettings)o;
        return Objects.equals(this.enabled, videoSettings.enabled) && Objects.equals(this.agent, videoSettings.agent) && Objects.equals(this.user, videoSettings.user);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.agent, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoSettings {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    agent: ").append(this.toIndentedString(this.agent)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

