/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.UsersRulesLockedCriteriaSettingsCriteria;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Users rule type-specific settings response")
public class UsersRulesRuleSettings
implements Serializable {
    private List<AllowedContainersEnum> allowedContainers = null;
    private List<UsersRulesLockedCriteriaSettingsCriteria> lockedCriteria = null;

    public UsersRulesRuleSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.allowedContainers = new ArrayList<AllowedContainersEnum>();
            this.lockedCriteria = new ArrayList<UsersRulesLockedCriteriaSettingsCriteria>();
        }
    }

    @ApiModelProperty(example="null", value="The allowed containers for the rule")
    @JsonProperty(value="allowedContainers")
    public List<AllowedContainersEnum> getAllowedContainers() {
        return this.allowedContainers;
    }

    @ApiModelProperty(example="null", value="The locked criteria settings for the rule")
    @JsonProperty(value="lockedCriteria")
    public List<UsersRulesLockedCriteriaSettingsCriteria> getLockedCriteria() {
        return this.lockedCriteria;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsersRulesRuleSettings usersRulesRuleSettings = (UsersRulesRuleSettings)o;
        return Objects.equals(this.allowedContainers, usersRulesRuleSettings.allowedContainers) && Objects.equals(this.lockedCriteria, usersRulesRuleSettings.lockedCriteria);
    }

    public int hashCode() {
        return Objects.hash(this.allowedContainers, this.lockedCriteria);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsersRulesRuleSettings {\n");
        sb.append("    allowedContainers: ").append(this.toIndentedString(this.allowedContainers)).append("\n");
        sb.append("    lockedCriteria: ").append(this.toIndentedString(this.lockedCriteria)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AllowedContainersEnumDeserializer.class)
    public static enum AllowedContainersEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACDSKILL("AcdSkill"),
        BUSINESSUNIT("BusinessUnit"),
        DIRECTORYGROUP("DirectoryGroup"),
        DIVISION("Division"),
        LANGUAGE("Language"),
        LOCATION("Location"),
        MANAGEMENTUNIT("ManagementUnit"),
        QUEUE("Queue"),
        REPORTSTO("ReportsTo"),
        STAFFINGGROUP("StaffingGroup"),
        TEAM("Team"),
        USER("User");

        private String value;

        private AllowedContainersEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AllowedContainersEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AllowedContainersEnum value : AllowedContainersEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AllowedContainersEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AllowedContainersEnumDeserializer
    extends StdDeserializer<AllowedContainersEnum> {
        public AllowedContainersEnumDeserializer() {
            super(AllowedContainersEnumDeserializer.class);
        }

        public AllowedContainersEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AllowedContainersEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

