/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.Segment;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ScreenMonitoring
implements Serializable {
    private String id = null;
    private InitialStateEnum initialState = null;
    private StateEnum state = null;
    private List<Segment> segments = null;
    private DisconnectTypeEnum disconnectType = null;
    private String provider = null;
    private AddressableEntityRef targetUser = null;
    private AddressableEntityRef screenMonitoring = null;
    private MonitoringTypeEnum monitoringType = null;
    private Long count = null;
    private Date connectedTime = null;
    private Date disconnectedTime = null;

    public ScreenMonitoring() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.segments = new ArrayList<Segment>();
        }
    }

    public ScreenMonitoring id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for this communication.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ScreenMonitoring initialState(InitialStateEnum initialState) {
        this.initialState = initialState;
        return this;
    }

    @ApiModelProperty(example="null", value="The initial connection state of this communication.")
    @JsonProperty(value="initialState")
    public InitialStateEnum getInitialState() {
        return this.initialState;
    }

    public void setInitialState(InitialStateEnum initialState) {
        this.initialState = initialState;
    }

    public ScreenMonitoring state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The connection state of this communication.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public ScreenMonitoring segments(List<Segment> segments) {
        this.segments = segments;
        return this;
    }

    @ApiModelProperty(example="null", value="The time line of the participant's Screen Monitoring media, divided into activity segments.")
    @JsonProperty(value="segments")
    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public ScreenMonitoring disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public ScreenMonitoring provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider of Screen Monitoring media.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public ScreenMonitoring targetUser(AddressableEntityRef targetUser) {
        this.targetUser = targetUser;
        return this;
    }

    @ApiModelProperty(example="null", value="The user participant who is being screen monitored.")
    @JsonProperty(value="targetUser")
    public AddressableEntityRef getTargetUser() {
        return this.targetUser;
    }

    public void setTargetUser(AddressableEntityRef targetUser) {
        this.targetUser = targetUser;
    }

    public ScreenMonitoring screenMonitoring(AddressableEntityRef screenMonitoring) {
        this.screenMonitoring = screenMonitoring;
        return this;
    }

    @ApiModelProperty(example="null", value="Screen Monitoring identifier unique to the sourceUserId-targetUserId pair.")
    @JsonProperty(value="screenMonitoring")
    public AddressableEntityRef getScreenMonitoring() {
        return this.screenMonitoring;
    }

    public void setScreenMonitoring(AddressableEntityRef screenMonitoring) {
        this.screenMonitoring = screenMonitoring;
    }

    public ScreenMonitoring monitoringType(MonitoringTypeEnum monitoringType) {
        this.monitoringType = monitoringType;
        return this;
    }

    @ApiModelProperty(example="null", value="The screen monitoring type.")
    @JsonProperty(value="monitoringType")
    public MonitoringTypeEnum getMonitoringType() {
        return this.monitoringType;
    }

    public void setMonitoringType(MonitoringTypeEnum monitoringType) {
        this.monitoringType = monitoringType;
    }

    public ScreenMonitoring count(Long count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of Screen Monitoring sessions the targetUserId is involved in.")
    @JsonProperty(value="count")
    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public ScreenMonitoring connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public ScreenMonitoring disconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="disconnectedTime")
    public Date getDisconnectedTime() {
        return this.disconnectedTime;
    }

    public void setDisconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreenMonitoring screenMonitoring = (ScreenMonitoring)o;
        return Objects.equals(this.id, screenMonitoring.id) && Objects.equals((Object)this.initialState, (Object)screenMonitoring.initialState) && Objects.equals((Object)this.state, (Object)screenMonitoring.state) && Objects.equals(this.segments, screenMonitoring.segments) && Objects.equals((Object)this.disconnectType, (Object)screenMonitoring.disconnectType) && Objects.equals(this.provider, screenMonitoring.provider) && Objects.equals(this.targetUser, screenMonitoring.targetUser) && Objects.equals(this.screenMonitoring, screenMonitoring.screenMonitoring) && Objects.equals((Object)this.monitoringType, (Object)screenMonitoring.monitoringType) && Objects.equals(this.count, screenMonitoring.count) && Objects.equals(this.connectedTime, screenMonitoring.connectedTime) && Objects.equals(this.disconnectedTime, screenMonitoring.disconnectedTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.initialState, this.state, this.segments, this.disconnectType, this.provider, this.targetUser, this.screenMonitoring, this.monitoringType, this.count, this.connectedTime, this.disconnectedTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScreenMonitoring {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    initialState: ").append(this.toIndentedString((Object)this.initialState)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    targetUser: ").append(this.toIndentedString(this.targetUser)).append("\n");
        sb.append("    screenMonitoring: ").append(this.toIndentedString(this.screenMonitoring)).append("\n");
        sb.append("    monitoringType: ").append(this.toIndentedString((Object)this.monitoringType)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    disconnectedTime: ").append(this.toIndentedString(this.disconnectedTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=InitialStateEnumDeserializer.class)
    public static enum InitialStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("none"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected");

        private String value;

        private InitialStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static InitialStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (InitialStateEnum value : InitialStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return InitialStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("none"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DisconnectTypeEnumDeserializer.class)
    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SYSTEM("system");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MonitoringTypeEnumDeserializer.class)
    public static enum MonitoringTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        AGENTLEVEL("AgentLevel"),
        CONVERSATIONLEVEL("ConversationLevel");

        private String value;

        private MonitoringTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MonitoringTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MonitoringTypeEnum value : MonitoringTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MonitoringTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MonitoringTypeEnumDeserializer
    extends StdDeserializer<MonitoringTypeEnum> {
        public MonitoringTypeEnumDeserializer() {
            super(MonitoringTypeEnumDeserializer.class);
        }

        public MonitoringTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MonitoringTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DisconnectTypeEnumDeserializer
    extends StdDeserializer<DisconnectTypeEnum> {
        public DisconnectTypeEnumDeserializer() {
            super(DisconnectTypeEnumDeserializer.class);
        }

        public DisconnectTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DisconnectTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class InitialStateEnumDeserializer
    extends StdDeserializer<InitialStateEnum> {
        public InitialStateEnumDeserializer() {
            super(InitialStateEnumDeserializer.class);
        }

        public InitialStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return InitialStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

