/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.SchedulingNoForecastOptionsRequest;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class SchedulingOptionsRequest
implements Serializable {
    private SchedulingNoForecastOptionsRequest noForecastOptions = null;
    private ActivitySmoothingTypeEnum activitySmoothingType = null;
    private Boolean induceScheduleVariability = null;

    public SchedulingOptionsRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public SchedulingOptionsRequest noForecastOptions(SchedulingNoForecastOptionsRequest noForecastOptions) {
        this.noForecastOptions = noForecastOptions;
        return this;
    }

    @ApiModelProperty(example="null", value="Schedule generation options to apply if no forecast is supplied")
    @JsonProperty(value="noForecastOptions")
    public SchedulingNoForecastOptionsRequest getNoForecastOptions() {
        return this.noForecastOptions;
    }

    public void setNoForecastOptions(SchedulingNoForecastOptionsRequest noForecastOptions) {
        this.noForecastOptions = noForecastOptions;
    }

    public SchedulingOptionsRequest activitySmoothingType(ActivitySmoothingTypeEnum activitySmoothingType) {
        this.activitySmoothingType = activitySmoothingType;
        return this;
    }

    @ApiModelProperty(example="null", value="Overrides the default BU level activity smoothing type for this schedule generation")
    @JsonProperty(value="activitySmoothingType")
    public ActivitySmoothingTypeEnum getActivitySmoothingType() {
        return this.activitySmoothingType;
    }

    public void setActivitySmoothingType(ActivitySmoothingTypeEnum activitySmoothingType) {
        this.activitySmoothingType = activitySmoothingType;
    }

    public SchedulingOptionsRequest induceScheduleVariability(Boolean induceScheduleVariability) {
        this.induceScheduleVariability = induceScheduleVariability;
        return this;
    }

    @ApiModelProperty(example="null", value="Overrides the default BU level induce schedule variability setting for this schedule generation")
    @JsonProperty(value="induceScheduleVariability")
    public Boolean getInduceScheduleVariability() {
        return this.induceScheduleVariability;
    }

    public void setInduceScheduleVariability(Boolean induceScheduleVariability) {
        this.induceScheduleVariability = induceScheduleVariability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulingOptionsRequest schedulingOptionsRequest = (SchedulingOptionsRequest)o;
        return Objects.equals(this.noForecastOptions, schedulingOptionsRequest.noForecastOptions) && Objects.equals((Object)this.activitySmoothingType, (Object)schedulingOptionsRequest.activitySmoothingType) && Objects.equals(this.induceScheduleVariability, schedulingOptionsRequest.induceScheduleVariability);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.noForecastOptions, this.activitySmoothingType, this.induceScheduleVariability});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SchedulingOptionsRequest {\n");
        sb.append("    noForecastOptions: ").append(this.toIndentedString(this.noForecastOptions)).append("\n");
        sb.append("    activitySmoothingType: ").append(this.toIndentedString((Object)this.activitySmoothingType)).append("\n");
        sb.append("    induceScheduleVariability: ").append(this.toIndentedString(this.induceScheduleVariability)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActivitySmoothingTypeEnumDeserializer.class)
    public static enum ActivitySmoothingTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        REDUCECONCURRENTACTIVITIESACROSSBU("ReduceConcurrentActivitiesAcrossBu"),
        REDUCECONCURRENTACTIVITIESACROSSMU("ReduceConcurrentActivitiesAcrossMu"),
        CONSISTENTSERVICELEVEL("ConsistentServiceLevel");

        private String value;

        private ActivitySmoothingTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActivitySmoothingTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActivitySmoothingTypeEnum value : ActivitySmoothingTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActivitySmoothingTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActivitySmoothingTypeEnumDeserializer
    extends StdDeserializer<ActivitySmoothingTypeEnum> {
        public ActivitySmoothingTypeEnumDeserializer() {
            super(ActivitySmoothingTypeEnumDeserializer.class);
        }

        public ActivitySmoothingTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActivitySmoothingTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

