/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class QualityEvaluationScoreItem
implements Serializable {
    private String evaluationId = null;
    private String conversationId = null;
    private Date conversationDate = null;
    private Date conversationEndDate = null;
    private String formName = null;
    private Integer points = null;
    private Double evaluationScore = null;
    private Integer maxPoints = null;
    private List<MediaTypesEnum> mediaTypes = null;

    public QualityEvaluationScoreItem() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.mediaTypes = new ArrayList<MediaTypesEnum>();
        }
    }

    @ApiModelProperty(example="null", value="The id of evaluation")
    @JsonProperty(value="evaluationId")
    public String getEvaluationId() {
        return this.evaluationId;
    }

    @ApiModelProperty(example="null", value="The id of conversation")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    @ApiModelProperty(example="null", value="The date of conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="conversationDate")
    public Date getConversationDate() {
        return this.conversationDate;
    }

    @ApiModelProperty(example="null", value="The end date of conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="conversationEndDate")
    public Date getConversationEndDate() {
        return this.conversationEndDate;
    }

    @ApiModelProperty(example="null", value="The name of form")
    @JsonProperty(value="formName")
    public String getFormName() {
        return this.formName;
    }

    @ApiModelProperty(example="null", value="Gamification points earned for this metric")
    @JsonProperty(value="points")
    public Integer getPoints() {
        return this.points;
    }

    @ApiModelProperty(example="null", value="The quality score of evaluation as a percentage")
    @JsonProperty(value="evaluationScore")
    public Double getEvaluationScore() {
        return this.evaluationScore;
    }

    @ApiModelProperty(example="null", value="The maximum Gamification points a user may earn for this metric")
    @JsonProperty(value="maxPoints")
    public Integer getMaxPoints() {
        return this.maxPoints;
    }

    public QualityEvaluationScoreItem mediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of media types for the metric")
    @JsonProperty(value="mediaTypes")
    public List<MediaTypesEnum> getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualityEvaluationScoreItem qualityEvaluationScoreItem = (QualityEvaluationScoreItem)o;
        return Objects.equals(this.evaluationId, qualityEvaluationScoreItem.evaluationId) && Objects.equals(this.conversationId, qualityEvaluationScoreItem.conversationId) && Objects.equals(this.conversationDate, qualityEvaluationScoreItem.conversationDate) && Objects.equals(this.conversationEndDate, qualityEvaluationScoreItem.conversationEndDate) && Objects.equals(this.formName, qualityEvaluationScoreItem.formName) && Objects.equals(this.points, qualityEvaluationScoreItem.points) && Objects.equals(this.evaluationScore, qualityEvaluationScoreItem.evaluationScore) && Objects.equals(this.maxPoints, qualityEvaluationScoreItem.maxPoints) && Objects.equals(this.mediaTypes, qualityEvaluationScoreItem.mediaTypes);
    }

    public int hashCode() {
        return Objects.hash(this.evaluationId, this.conversationId, this.conversationDate, this.conversationEndDate, this.formName, this.points, this.evaluationScore, this.maxPoints, this.mediaTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QualityEvaluationScoreItem {\n");
        sb.append("    evaluationId: ").append(this.toIndentedString(this.evaluationId)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    conversationDate: ").append(this.toIndentedString(this.conversationDate)).append("\n");
        sb.append("    conversationEndDate: ").append(this.toIndentedString(this.conversationEndDate)).append("\n");
        sb.append("    formName: ").append(this.toIndentedString(this.formName)).append("\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("    evaluationScore: ").append(this.toIndentedString(this.evaluationScore)).append("\n");
        sb.append("    maxPoints: ").append(this.toIndentedString(this.maxPoints)).append("\n");
        sb.append("    mediaTypes: ").append(this.toIndentedString(this.mediaTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypesEnumDeserializer.class)
    public static enum MediaTypesEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALLBACK("callback"),
        CHAT("chat"),
        COBROWSE("cobrowse"),
        EMAIL("email"),
        INTERNALMESSAGE("internalmessage"),
        MESSAGE("message"),
        SCREENMONITORING("screenmonitoring"),
        SCREENSHARE("screenshare"),
        UNKNOWN("unknown"),
        VIDEO("video"),
        VOICE("voice");

        private String value;

        private MediaTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypesEnum value : MediaTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypesEnumDeserializer
    extends StdDeserializer<MediaTypesEnum> {
        public MediaTypesEnumDeserializer() {
            super(MediaTypesEnumDeserializer.class);
        }

        public MediaTypesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

