/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class PushIntegration
implements Serializable {
    private String id = null;
    private ProviderEnum provider = null;

    public PushIntegration() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public PushIntegration id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The mobile push integration id associated with the deployment")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PushIntegration provider(ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The integration provider associated with the deployment")
    @JsonProperty(value="provider")
    public ProviderEnum getProvider() {
        return this.provider;
    }

    public void setProvider(ProviderEnum provider) {
        this.provider = provider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushIntegration pushIntegration = (PushIntegration)o;
        return Objects.equals(this.id, pushIntegration.id) && Objects.equals((Object)this.provider, (Object)pushIntegration.provider);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.provider});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PushIntegration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ProviderEnumDeserializer.class)
    public static enum ProviderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        APNS("APNS"),
        FCM("FCM");

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ProviderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ProviderEnum value : ProviderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ProviderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ProviderEnumDeserializer
    extends StdDeserializer<ProviderEnum> {
        public ProviderEnumDeserializer() {
            super(ProviderEnumDeserializer.class);
        }

        public ProviderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ProviderEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

