/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class Phrase
implements Serializable {
    private String text = null;
    private StrictnessEnum strictness = null;
    private SentimentEnum sentiment = null;
    private Boolean isAIGenerated = null;

    public Phrase() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public Phrase text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The phrase text")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Phrase strictness(StrictnessEnum strictness) {
        this.strictness = strictness;
        return this;
    }

    @ApiModelProperty(example="null", value="The phrase strictness, default value is null")
    @JsonProperty(value="strictness")
    public StrictnessEnum getStrictness() {
        return this.strictness;
    }

    public void setStrictness(StrictnessEnum strictness) {
        this.strictness = strictness;
    }

    public Phrase sentiment(SentimentEnum sentiment) {
        this.sentiment = sentiment;
        return this;
    }

    @ApiModelProperty(example="null", value="The phrase sentiment, default value is Unspecified. Note: Sentiment value for phrases is currently not in use and has no impact to the system.")
    @JsonProperty(value="sentiment")
    public SentimentEnum getSentiment() {
        return this.sentiment;
    }

    public void setSentiment(SentimentEnum sentiment) {
        this.sentiment = sentiment;
    }

    public Phrase isAIGenerated(Boolean isAIGenerated) {
        this.isAIGenerated = isAIGenerated;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the phrase is AI generated")
    @JsonProperty(value="isAIGenerated")
    public Boolean getIsAIGenerated() {
        return this.isAIGenerated;
    }

    public void setIsAIGenerated(Boolean isAIGenerated) {
        this.isAIGenerated = isAIGenerated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Phrase phrase = (Phrase)o;
        return Objects.equals(this.text, phrase.text) && Objects.equals((Object)this.strictness, (Object)phrase.strictness) && Objects.equals((Object)this.sentiment, (Object)phrase.sentiment) && Objects.equals(this.isAIGenerated, phrase.isAIGenerated);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.text, this.strictness, this.sentiment, this.isAIGenerated});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Phrase {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    strictness: ").append(this.toIndentedString((Object)this.strictness)).append("\n");
        sb.append("    sentiment: ").append(this.toIndentedString((Object)this.sentiment)).append("\n");
        sb.append("    isAIGenerated: ").append(this.toIndentedString(this.isAIGenerated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StrictnessEnumDeserializer.class)
    public static enum StrictnessEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        _1("1"),
        _55("55"),
        _65("65"),
        _72("72"),
        _85("85"),
        _90("90");

        private String value;

        private StrictnessEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StrictnessEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StrictnessEnum value : StrictnessEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StrictnessEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SentimentEnumDeserializer.class)
    public static enum SentimentEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNSPECIFIED("Unspecified"),
        POSITIVE("Positive"),
        NEUTRAL("Neutral"),
        NEGATIVE("Negative");

        private String value;

        private SentimentEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SentimentEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SentimentEnum value : SentimentEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SentimentEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SentimentEnumDeserializer
    extends StdDeserializer<SentimentEnum> {
        public SentimentEnumDeserializer() {
            super(SentimentEnumDeserializer.class);
        }

        public SentimentEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SentimentEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StrictnessEnumDeserializer
    extends StdDeserializer<StrictnessEnum> {
        public StrictnessEnumDeserializer() {
            super(StrictnessEnumDeserializer.class);
        }

        public StrictnessEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StrictnessEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

