/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.PerformancePredictionOutputs;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class PerformancePredictionRecalculationResponse
implements Serializable {
    private String operationId = null;
    private String downloadUrl = null;
    private PerformancePredictionOutputs downloadResult = null;
    private StateEnum state = null;

    public PerformancePredictionRecalculationResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public PerformancePredictionRecalculationResponse operationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The operationId for which to listen")
    @JsonProperty(value="operationId")
    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public PerformancePredictionRecalculationResponse downloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The url to GET the results of the performance prediction. This field is populated only if query state is 'Complete'")
    @JsonProperty(value="downloadUrl")
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public PerformancePredictionRecalculationResponse downloadResult(PerformancePredictionOutputs downloadResult) {
        this.downloadResult = downloadResult;
        return this;
    }

    @ApiModelProperty(example="null", value="Result will always come via downloadUrls; however the schema is included for documentation")
    @JsonProperty(value="downloadResult")
    public PerformancePredictionOutputs getDownloadResult() {
        return this.downloadResult;
    }

    public void setDownloadResult(PerformancePredictionOutputs downloadResult) {
        this.downloadResult = downloadResult;
    }

    public PerformancePredictionRecalculationResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The state of the performance prediction")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerformancePredictionRecalculationResponse performancePredictionRecalculationResponse = (PerformancePredictionRecalculationResponse)o;
        return Objects.equals(this.operationId, performancePredictionRecalculationResponse.operationId) && Objects.equals(this.downloadUrl, performancePredictionRecalculationResponse.downloadUrl) && Objects.equals(this.downloadResult, performancePredictionRecalculationResponse.downloadResult) && Objects.equals((Object)this.state, (Object)performancePredictionRecalculationResponse.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operationId, this.downloadUrl, this.downloadResult, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PerformancePredictionRecalculationResponse {\n");
        sb.append("    operationId: ").append(this.toIndentedString(this.operationId)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    downloadResult: ").append(this.toIndentedString(this.downloadResult)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PROCESSING("Processing"),
        COMPLETE("Complete"),
        ERROR("Error");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

