/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.UsageQuerySortBy;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OrganizationPublicApiUsageQueryRequest
implements Serializable {
    private String interval = null;
    private GranularityEnum granularity = null;
    private List<UsageQuerySortBy> sortBy = null;
    private List<MetricsEnum> metrics = null;
    private List<String> templateUris = null;
    private List<HttpMethodsEnum> httpMethods = null;
    private List<String> platforms = null;
    private List<GroupByEnum> groupBy = null;
    private List<String> userIds = null;
    private List<String> oauthClientIds = null;

    public OrganizationPublicApiUsageQueryRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.sortBy = new ArrayList<UsageQuerySortBy>();
            this.metrics = new ArrayList<MetricsEnum>();
            this.templateUris = new ArrayList<String>();
            this.httpMethods = new ArrayList<HttpMethodsEnum>();
            this.platforms = new ArrayList<String>();
            this.groupBy = new ArrayList<GroupByEnum>();
            this.userIds = new ArrayList<String>();
            this.oauthClientIds = new ArrayList<String>();
        }
    }

    public OrganizationPublicApiUsageQueryRequest interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Specify the interval to query on. Start and end are inclusive. Start date cannot be more than a year ago. End date cannot be more than 90 days after the start. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public OrganizationPublicApiUsageQueryRequest granularity(GranularityEnum granularity) {
        this.granularity = granularity;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify the granularity to aggregate the data to.")
    @JsonProperty(value="granularity")
    public GranularityEnum getGranularity() {
        return this.granularity;
    }

    public void setGranularity(GranularityEnum granularity) {
        this.granularity = granularity;
    }

    public OrganizationPublicApiUsageQueryRequest sortBy(List<UsageQuerySortBy> sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify how to sort the returned data.")
    @JsonProperty(value="sortBy")
    public List<UsageQuerySortBy> getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(List<UsageQuerySortBy> sortBy) {
        this.sortBy = sortBy;
    }

    public OrganizationPublicApiUsageQueryRequest metrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify which metrics you want returned (all will be returned by default).")
    @JsonProperty(value="metrics")
    public List<MetricsEnum> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
    }

    public OrganizationPublicApiUsageQueryRequest templateUris(List<String> templateUris) {
        this.templateUris = templateUris;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify if you only want a subset of templateUris represented in the query.")
    @JsonProperty(value="templateUris")
    public List<String> getTemplateUris() {
        return this.templateUris;
    }

    public void setTemplateUris(List<String> templateUris) {
        this.templateUris = templateUris;
    }

    public OrganizationPublicApiUsageQueryRequest httpMethods(List<HttpMethodsEnum> httpMethods) {
        this.httpMethods = httpMethods;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify if you only want a subset of httpMethods represented in the query.")
    @JsonProperty(value="httpMethods")
    public List<HttpMethodsEnum> getHttpMethods() {
        return this.httpMethods;
    }

    public void setHttpMethods(List<HttpMethodsEnum> httpMethods) {
        this.httpMethods = httpMethods;
    }

    public OrganizationPublicApiUsageQueryRequest platforms(List<String> platforms) {
        this.platforms = platforms;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify if you only want a subset of platforms represented in the query.")
    @JsonProperty(value="platforms")
    public List<String> getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(List<String> platforms) {
        this.platforms = platforms;
    }

    public OrganizationPublicApiUsageQueryRequest groupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify how to aggregate the data (by default the data is not aggregated).")
    @JsonProperty(value="groupBy")
    public List<GroupByEnum> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
    }

    public OrganizationPublicApiUsageQueryRequest userIds(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify if you only want a subset of userIds represented in the query.")
    @JsonProperty(value="userIds")
    public List<String> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public OrganizationPublicApiUsageQueryRequest oauthClientIds(List<String> oauthClientIds) {
        this.oauthClientIds = oauthClientIds;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify if you only want a subset of oauthClientIds represented in the query.")
    @JsonProperty(value="oauthClientIds")
    public List<String> getOauthClientIds() {
        return this.oauthClientIds;
    }

    public void setOauthClientIds(List<String> oauthClientIds) {
        this.oauthClientIds = oauthClientIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationPublicApiUsageQueryRequest organizationPublicApiUsageQueryRequest = (OrganizationPublicApiUsageQueryRequest)o;
        return Objects.equals(this.interval, organizationPublicApiUsageQueryRequest.interval) && Objects.equals((Object)this.granularity, (Object)organizationPublicApiUsageQueryRequest.granularity) && Objects.equals(this.sortBy, organizationPublicApiUsageQueryRequest.sortBy) && Objects.equals(this.metrics, organizationPublicApiUsageQueryRequest.metrics) && Objects.equals(this.templateUris, organizationPublicApiUsageQueryRequest.templateUris) && Objects.equals(this.httpMethods, organizationPublicApiUsageQueryRequest.httpMethods) && Objects.equals(this.platforms, organizationPublicApiUsageQueryRequest.platforms) && Objects.equals(this.groupBy, organizationPublicApiUsageQueryRequest.groupBy) && Objects.equals(this.userIds, organizationPublicApiUsageQueryRequest.userIds) && Objects.equals(this.oauthClientIds, organizationPublicApiUsageQueryRequest.oauthClientIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.granularity, this.sortBy, this.metrics, this.templateUris, this.httpMethods, this.platforms, this.groupBy, this.userIds, this.oauthClientIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrganizationPublicApiUsageQueryRequest {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("    sortBy: ").append(this.toIndentedString(this.sortBy)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    templateUris: ").append(this.toIndentedString(this.templateUris)).append("\n");
        sb.append("    httpMethods: ").append(this.toIndentedString(this.httpMethods)).append("\n");
        sb.append("    platforms: ").append(this.toIndentedString(this.platforms)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    userIds: ").append(this.toIndentedString(this.userIds)).append("\n");
        sb.append("    oauthClientIds: ").append(this.toIndentedString(this.oauthClientIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=GranularityEnumDeserializer.class)
    public static enum GranularityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAY("Day"),
        WEEK("Week"),
        MONTH("Month");

        private String value;

        private GranularityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GranularityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GranularityEnum value : GranularityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GranularityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=GroupByEnumDeserializer.class)
    public static enum GroupByEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OAUTHCLIENTNAME("OauthClientName"),
        OAUTHCLIENTID("OauthClientId"),
        USERID("UserId"),
        HTTPMETHOD("HttpMethod"),
        TEMPLATEURI("TemplateUri"),
        PLATFORM("Platform");

        private String value;

        private GroupByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GroupByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GroupByEnum value : GroupByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GroupByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GroupByEnumDeserializer
    extends StdDeserializer<GroupByEnum> {
        public GroupByEnumDeserializer() {
            super(GroupByEnumDeserializer.class);
        }

        public GroupByEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GroupByEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=HttpMethodsEnumDeserializer.class)
    public static enum HttpMethodsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GET("GET"),
        POST("POST"),
        PUT("PUT"),
        PATCH("PATCH"),
        DELETE("DELETE"),
        HEAD("HEAD");

        private String value;

        private HttpMethodsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static HttpMethodsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (HttpMethodsEnum value : HttpMethodsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return HttpMethodsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class HttpMethodsEnumDeserializer
    extends StdDeserializer<HttpMethodsEnum> {
        public HttpMethodsEnumDeserializer() {
            super(HttpMethodsEnumDeserializer.class);
        }

        public HttpMethodsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return HttpMethodsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MetricsEnumDeserializer.class)
    public static enum MetricsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        REQUESTS("Requests"),
        STATUS200("Status200"),
        STATUS300("Status300"),
        STATUS400("Status400"),
        STATUS429("Status429"),
        STATUS500("Status500");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricsEnum value : MetricsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MetricsEnumDeserializer
    extends StdDeserializer<MetricsEnum> {
        public MetricsEnumDeserializer() {
            super(MetricsEnumDeserializer.class);
        }

        public MetricsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class GranularityEnumDeserializer
    extends StdDeserializer<GranularityEnum> {
        public GranularityEnumDeserializer() {
            super(GranularityEnumDeserializer.class);
        }

        public GranularityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GranularityEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

