/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

public class OrganizationPublicApiUsage
implements Serializable {
    private LocalDate date = null;
    private String platform = null;
    private HttpMethodEnum httpMethod = null;
    private String templateUri = null;
    private Long requestCount = null;
    private Long status200 = null;
    private Long status300 = null;
    private Long status400 = null;
    private Long status429 = null;
    private Long status500 = null;
    private DomainEntityRef oauthClient = null;
    private UserReference user = null;

    public OrganizationPublicApiUsage() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public OrganizationPublicApiUsage date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(example="null", value="The date of the usage. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="date")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public OrganizationPublicApiUsage platform(String platform) {
        this.platform = platform;
        return this;
    }

    @ApiModelProperty(example="null", value="The platform the request(s) is/were made on.")
    @JsonProperty(value="platform")
    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public OrganizationPublicApiUsage httpMethod(HttpMethodEnum httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    @ApiModelProperty(example="null", value="The http method of the request(s)")
    @JsonProperty(value="httpMethod")
    public HttpMethodEnum getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethodEnum httpMethod) {
        this.httpMethod = httpMethod;
    }

    public OrganizationPublicApiUsage templateUri(String templateUri) {
        this.templateUri = templateUri;
        return this;
    }

    @ApiModelProperty(example="null", value="The templateUri of the request(s).")
    @JsonProperty(value="templateUri")
    public String getTemplateUri() {
        return this.templateUri;
    }

    public void setTemplateUri(String templateUri) {
        this.templateUri = templateUri;
    }

    public OrganizationPublicApiUsage requestCount(Long requestCount) {
        this.requestCount = requestCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The total number of requests.")
    @JsonProperty(value="requestCount")
    public Long getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(Long requestCount) {
        this.requestCount = requestCount;
    }

    public OrganizationPublicApiUsage status200(Long status200) {
        this.status200 = status200;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of requests resulting in a 2xx HTTP status code.")
    @JsonProperty(value="status200")
    public Long getStatus200() {
        return this.status200;
    }

    public void setStatus200(Long status200) {
        this.status200 = status200;
    }

    public OrganizationPublicApiUsage status300(Long status300) {
        this.status300 = status300;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of requests resulting in a 3xx HTTP status code.")
    @JsonProperty(value="status300")
    public Long getStatus300() {
        return this.status300;
    }

    public void setStatus300(Long status300) {
        this.status300 = status300;
    }

    public OrganizationPublicApiUsage status400(Long status400) {
        this.status400 = status400;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of requests resulting in a 4xx HTTP status code.")
    @JsonProperty(value="status400")
    public Long getStatus400() {
        return this.status400;
    }

    public void setStatus400(Long status400) {
        this.status400 = status400;
    }

    public OrganizationPublicApiUsage status429(Long status429) {
        this.status429 = status429;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of requests resulting in a 429 HTTP status code.")
    @JsonProperty(value="status429")
    public Long getStatus429() {
        return this.status429;
    }

    public void setStatus429(Long status429) {
        this.status429 = status429;
    }

    public OrganizationPublicApiUsage status500(Long status500) {
        this.status500 = status500;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of requests resulting in a 5xx HTTP status code.")
    @JsonProperty(value="status500")
    public Long getStatus500() {
        return this.status500;
    }

    public void setStatus500(Long status500) {
        this.status500 = status500;
    }

    public OrganizationPublicApiUsage oauthClient(DomainEntityRef oauthClient) {
        this.oauthClient = oauthClient;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the oauthClient that made the request(s).")
    @JsonProperty(value="oauthClient")
    public DomainEntityRef getOauthClient() {
        return this.oauthClient;
    }

    public void setOauthClient(DomainEntityRef oauthClient) {
        this.oauthClient = oauthClient;
    }

    public OrganizationPublicApiUsage user(UserReference user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the user who made the request(s).")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    public void setUser(UserReference user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationPublicApiUsage organizationPublicApiUsage = (OrganizationPublicApiUsage)o;
        return Objects.equals(this.date, organizationPublicApiUsage.date) && Objects.equals(this.platform, organizationPublicApiUsage.platform) && Objects.equals((Object)this.httpMethod, (Object)organizationPublicApiUsage.httpMethod) && Objects.equals(this.templateUri, organizationPublicApiUsage.templateUri) && Objects.equals(this.requestCount, organizationPublicApiUsage.requestCount) && Objects.equals(this.status200, organizationPublicApiUsage.status200) && Objects.equals(this.status300, organizationPublicApiUsage.status300) && Objects.equals(this.status400, organizationPublicApiUsage.status400) && Objects.equals(this.status429, organizationPublicApiUsage.status429) && Objects.equals(this.status500, organizationPublicApiUsage.status500) && Objects.equals(this.oauthClient, organizationPublicApiUsage.oauthClient) && Objects.equals(this.user, organizationPublicApiUsage.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.date, this.platform, this.httpMethod, this.templateUri, this.requestCount, this.status200, this.status300, this.status400, this.status429, this.status500, this.oauthClient, this.user});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrganizationPublicApiUsage {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString(this.platform)).append("\n");
        sb.append("    httpMethod: ").append(this.toIndentedString((Object)this.httpMethod)).append("\n");
        sb.append("    templateUri: ").append(this.toIndentedString(this.templateUri)).append("\n");
        sb.append("    requestCount: ").append(this.toIndentedString(this.requestCount)).append("\n");
        sb.append("    status200: ").append(this.toIndentedString(this.status200)).append("\n");
        sb.append("    status300: ").append(this.toIndentedString(this.status300)).append("\n");
        sb.append("    status400: ").append(this.toIndentedString(this.status400)).append("\n");
        sb.append("    status429: ").append(this.toIndentedString(this.status429)).append("\n");
        sb.append("    status500: ").append(this.toIndentedString(this.status500)).append("\n");
        sb.append("    oauthClient: ").append(this.toIndentedString(this.oauthClient)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=HttpMethodEnumDeserializer.class)
    public static enum HttpMethodEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GET("GET"),
        POST("POST"),
        PUT("PUT"),
        PATCH("PATCH"),
        DELETE("DELETE"),
        HEAD("HEAD");

        private String value;

        private HttpMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static HttpMethodEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (HttpMethodEnum value : HttpMethodEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return HttpMethodEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class HttpMethodEnumDeserializer
    extends StdDeserializer<HttpMethodEnum> {
        public HttpMethodEnumDeserializer() {
            super(HttpMethodEnumDeserializer.class);
        }

        public HttpMethodEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return HttpMethodEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

