/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Learning module summary data")
public class LearningModuleSummary
implements Serializable {
    private Integer assignedCount = null;
    private Integer completedCount = null;
    private Integer passedCount = null;
    private Float completedSum = null;

    public LearningModuleSummary() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public LearningModuleSummary assignedCount(Integer assignedCount) {
        this.assignedCount = assignedCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The total number of assignments assigned for a learning module")
    @JsonProperty(value="assignedCount")
    public Integer getAssignedCount() {
        return this.assignedCount;
    }

    public void setAssignedCount(Integer assignedCount) {
        this.assignedCount = assignedCount;
    }

    public LearningModuleSummary completedCount(Integer completedCount) {
        this.completedCount = completedCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of assignments completed for a learning module")
    @JsonProperty(value="completedCount")
    public Integer getCompletedCount() {
        return this.completedCount;
    }

    public void setCompletedCount(Integer completedCount) {
        this.completedCount = completedCount;
    }

    public LearningModuleSummary passedCount(Integer passedCount) {
        this.passedCount = passedCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of assignments passed for a learning module")
    @JsonProperty(value="passedCount")
    public Integer getPassedCount() {
        return this.passedCount;
    }

    public void setPassedCount(Integer passedCount) {
        this.passedCount = passedCount;
    }

    public LearningModuleSummary completedSum(Float completedSum) {
        this.completedSum = completedSum;
        return this;
    }

    @ApiModelProperty(example="null", value="The sum of assignment scores for a learning module")
    @JsonProperty(value="completedSum")
    public Float getCompletedSum() {
        return this.completedSum;
    }

    public void setCompletedSum(Float completedSum) {
        this.completedSum = completedSum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningModuleSummary learningModuleSummary = (LearningModuleSummary)o;
        return Objects.equals(this.assignedCount, learningModuleSummary.assignedCount) && Objects.equals(this.completedCount, learningModuleSummary.completedCount) && Objects.equals(this.passedCount, learningModuleSummary.passedCount) && Objects.equals(this.completedSum, learningModuleSummary.completedSum);
    }

    public int hashCode() {
        return Objects.hash(this.assignedCount, this.completedCount, this.passedCount, this.completedSum);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningModuleSummary {\n");
        sb.append("    assignedCount: ").append(this.toIndentedString(this.assignedCount)).append("\n");
        sb.append("    completedCount: ").append(this.toIndentedString(this.completedCount)).append("\n");
        sb.append("    passedCount: ").append(this.toIndentedString(this.passedCount)).append("\n");
        sb.append("    completedSum: ").append(this.toIndentedString(this.completedSum)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

