/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class LanguageOverride
implements Serializable {
    private String language = null;
    private String engine = null;
    private String voice = null;

    public LanguageOverride() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public LanguageOverride language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The language code of the language being overridden")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public LanguageOverride engine(String engine) {
        this.engine = engine;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the TTS engine to use for this language override")
    @JsonProperty(value="engine")
    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public LanguageOverride voice(String voice) {
        this.voice = voice;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the voice to use for this language override. The voice must be supported by the chosen engine.")
    @JsonProperty(value="voice")
    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String voice) {
        this.voice = voice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LanguageOverride languageOverride = (LanguageOverride)o;
        return Objects.equals(this.language, languageOverride.language) && Objects.equals(this.engine, languageOverride.engine) && Objects.equals(this.voice, languageOverride.voice);
    }

    public int hashCode() {
        return Objects.hash(this.language, this.engine, this.voice);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LanguageOverride {\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    engine: ").append(this.toIndentedString(this.engine)).append("\n");
        sb.append("    voice: ").append(this.toIndentedString(this.voice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

