/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Configuration for filtering tracking based on IP addresses.")
public class IpFilter
implements Serializable {
    private String ipAddress = null;
    private String name = null;

    public IpFilter() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public IpFilter ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="IP address or CIDR range to filter (e.g. '192.168.1.0/24').")
    @JsonProperty(value="ipAddress")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public IpFilter name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="Descriptive name for the IP address filter.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpFilter ipFilter = (IpFilter)o;
        return Objects.equals(this.ipAddress, ipFilter.ipAddress) && Objects.equals(this.name, ipFilter.name);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IpFilter {\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

