/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.InputMessage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Incoming Message request")
public class IncomingMessageRequest
implements Serializable {
    private String botId = null;
    private String botName = null;
    private String botVersion = null;
    private String integrationId = null;
    private String botSessionId = null;
    private String automateFlowExecId = null;
    private String conversationId = null;
    private String languageCode = null;
    private InputMessage inputMessage = null;
    private MessagingPlatformTypeEnum messagingPlatformType = null;
    private List<ChannelsEnum> channels = null;
    private Integer botSessionTimeout = null;
    private Map<String, String> parameters = null;

    public IncomingMessageRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.channels = new ArrayList<ChannelsEnum>();
        }
    }

    public IncomingMessageRequest botId(String botId) {
        this.botId = botId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The unique id of the bot.")
    @JsonProperty(value="botId")
    public String getBotId() {
        return this.botId;
    }

    public void setBotId(String botId) {
        this.botId = botId;
    }

    public IncomingMessageRequest botName(String botName) {
        this.botName = botName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the bot")
    @JsonProperty(value="botName")
    public String getBotName() {
        return this.botName;
    }

    public void setBotName(String botName) {
        this.botName = botName;
    }

    public IncomingMessageRequest botVersion(String botVersion) {
        this.botVersion = botVersion;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The version of the bot.")
    @JsonProperty(value="botVersion")
    public String getBotVersion() {
        return this.botVersion;
    }

    public void setBotVersion(String botVersion) {
        this.botVersion = botVersion;
    }

    public IncomingMessageRequest integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Integration Id for the bot's configuration")
    @JsonProperty(value="integrationId")
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public IncomingMessageRequest botSessionId(String botSessionId) {
        this.botSessionId = botSessionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the session. This id will be used for an entire conversation with the bot (a series of back and forth between the bot until the bot has fulfilled its intent).")
    @JsonProperty(value="botSessionId")
    public String getBotSessionId() {
        return this.botSessionId;
    }

    public void setBotSessionId(String botSessionId) {
        this.botSessionId = botSessionId;
    }

    public IncomingMessageRequest automateFlowExecId(String automateFlowExecId) {
        this.automateFlowExecId = automateFlowExecId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Execution ID of the Automate Flow.")
    @JsonProperty(value="automateFlowExecId")
    public String getAutomateFlowExecId() {
        return this.automateFlowExecId;
    }

    public void setAutomateFlowExecId(String automateFlowExecId) {
        this.automateFlowExecId = automateFlowExecId;
    }

    public IncomingMessageRequest conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Genesys conversation ID.")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public IncomingMessageRequest languageCode(String languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Language code for the conversation (e.g., 'en-US').")
    @JsonProperty(value="languageCode")
    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public IncomingMessageRequest inputMessage(InputMessage inputMessage) {
        this.inputMessage = inputMessage;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Message received from the user to send to the bot")
    @JsonProperty(value="inputMessage")
    public InputMessage getInputMessage() {
        return this.inputMessage;
    }

    public void setInputMessage(InputMessage inputMessage) {
        this.inputMessage = inputMessage;
    }

    public IncomingMessageRequest messagingPlatformType(MessagingPlatformTypeEnum messagingPlatformType) {
        this.messagingPlatformType = messagingPlatformType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of messaging platform being used")
    @JsonProperty(value="messagingPlatformType")
    public MessagingPlatformTypeEnum getMessagingPlatformType() {
        return this.messagingPlatformType;
    }

    public void setMessagingPlatformType(MessagingPlatformTypeEnum messagingPlatformType) {
        this.messagingPlatformType = messagingPlatformType;
    }

    public IncomingMessageRequest channels(List<ChannelsEnum> channels) {
        this.channels = channels;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The channels this bot is utilizing.")
    @JsonProperty(value="channels")
    public List<ChannelsEnum> getChannels() {
        return this.channels;
    }

    public void setChannels(List<ChannelsEnum> channels) {
        this.channels = channels;
    }

    public IncomingMessageRequest botSessionTimeout(Integer botSessionTimeout) {
        this.botSessionTimeout = botSessionTimeout;
        return this;
    }

    @ApiModelProperty(example="null", value="Timeout duration for bot session in minutes.")
    @JsonProperty(value="botSessionTimeout")
    public Integer getBotSessionTimeout() {
        return this.botSessionTimeout;
    }

    public void setBotSessionTimeout(Integer botSessionTimeout) {
        this.botSessionTimeout = botSessionTimeout;
    }

    public IncomingMessageRequest parameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    @ApiModelProperty(example="null", value="This is a map of string-string key, value pairs containing optional fields that can be passed to the bot for custom behavior, tracking, etc.")
    @JsonProperty(value="parameters")
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncomingMessageRequest incomingMessageRequest = (IncomingMessageRequest)o;
        return Objects.equals(this.botId, incomingMessageRequest.botId) && Objects.equals(this.botName, incomingMessageRequest.botName) && Objects.equals(this.botVersion, incomingMessageRequest.botVersion) && Objects.equals(this.integrationId, incomingMessageRequest.integrationId) && Objects.equals(this.botSessionId, incomingMessageRequest.botSessionId) && Objects.equals(this.automateFlowExecId, incomingMessageRequest.automateFlowExecId) && Objects.equals(this.conversationId, incomingMessageRequest.conversationId) && Objects.equals(this.languageCode, incomingMessageRequest.languageCode) && Objects.equals(this.inputMessage, incomingMessageRequest.inputMessage) && Objects.equals((Object)this.messagingPlatformType, (Object)incomingMessageRequest.messagingPlatformType) && Objects.equals(this.channels, incomingMessageRequest.channels) && Objects.equals(this.botSessionTimeout, incomingMessageRequest.botSessionTimeout) && Objects.equals(this.parameters, incomingMessageRequest.parameters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.botId, this.botName, this.botVersion, this.integrationId, this.botSessionId, this.automateFlowExecId, this.conversationId, this.languageCode, this.inputMessage, this.messagingPlatformType, this.channels, this.botSessionTimeout, this.parameters});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncomingMessageRequest {\n");
        sb.append("    botId: ").append(this.toIndentedString(this.botId)).append("\n");
        sb.append("    botName: ").append(this.toIndentedString(this.botName)).append("\n");
        sb.append("    botVersion: ").append(this.toIndentedString(this.botVersion)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    botSessionId: ").append(this.toIndentedString(this.botSessionId)).append("\n");
        sb.append("    automateFlowExecId: ").append(this.toIndentedString(this.automateFlowExecId)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    languageCode: ").append(this.toIndentedString(this.languageCode)).append("\n");
        sb.append("    inputMessage: ").append(this.toIndentedString(this.inputMessage)).append("\n");
        sb.append("    messagingPlatformType: ").append(this.toIndentedString((Object)this.messagingPlatformType)).append("\n");
        sb.append("    channels: ").append(this.toIndentedString(this.channels)).append("\n");
        sb.append("    botSessionTimeout: ").append(this.toIndentedString(this.botSessionTimeout)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MessagingPlatformTypeEnumDeserializer.class)
    public static enum MessagingPlatformTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PHONE("Phone"),
        SMS("SMS"),
        GENESYSWEBWIDGET("GenesysWebWidget"),
        FACEBOOKMESSENGER("FacebookMessenger"),
        WECHAT("WeChat"),
        WHATSAPP("Whatsapp"),
        APPLEBUSINESSCHAT("AppleBusinessChat"),
        APPLE("Apple"),
        TELEGRAM("Telegram"),
        SLACK("Slack"),
        SIGNAL("Signal"),
        LINE("Line"),
        DISCORD("Discord"),
        TWITTERDIRECTMESSAGE("TwitterDirectMessage"),
        OPEN("Open"),
        INSTAGRAM("Instagram"),
        OTHER("Other"),
        UNKNOWN("Unknown");

        private String value;

        private MessagingPlatformTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MessagingPlatformTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MessagingPlatformTypeEnum value : MessagingPlatformTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MessagingPlatformTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ChannelsEnumDeserializer.class)
    public static enum ChannelsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALL("Call"),
        CALLBACK("Callback"),
        MESSAGING("Messaging"),
        WEBCHAT("Webchat");

        private String value;

        private ChannelsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ChannelsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ChannelsEnum value : ChannelsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ChannelsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ChannelsEnumDeserializer
    extends StdDeserializer<ChannelsEnum> {
        public ChannelsEnumDeserializer() {
            super(ChannelsEnumDeserializer.class);
        }

        public ChannelsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ChannelsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MessagingPlatformTypeEnumDeserializer
    extends StdDeserializer<MessagingPlatformTypeEnum> {
        public MessagingPlatformTypeEnumDeserializer() {
            super(MessagingPlatformTypeEnumDeserializer.class);
        }

        public MessagingPlatformTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MessagingPlatformTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

