/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class IgnoredMinedEntity
implements Serializable {
    private String id = null;
    private String text = null;
    private ParticipantEnum participant = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private MediaTypeEnum mediaType = null;

    public IgnoredMinedEntity() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public IgnoredMinedEntity id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="123e4567-e89b-12d3-a456-426614174000", required=true, value="Unique identifier for the ignored entity")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IgnoredMinedEntity text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="want to pay bill", required=true, value="Text of the ignored entity")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public IgnoredMinedEntity participant(ParticipantEnum participant) {
        this.participant = participant;
        return this;
    }

    @ApiModelProperty(example="Customer", required=true, value="Type of participant")
    @JsonProperty(value="participant")
    public ParticipantEnum getParticipant() {
        return this.participant;
    }

    public void setParticipant(ParticipantEnum participant) {
        this.participant = participant;
    }

    public IgnoredMinedEntity dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date when the ignored entity was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public IgnoredMinedEntity dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date when the ignored entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public IgnoredMinedEntity mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="Media Type for the entity (Optional)")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgnoredMinedEntity ignoredMinedEntity = (IgnoredMinedEntity)o;
        return Objects.equals(this.id, ignoredMinedEntity.id) && Objects.equals(this.text, ignoredMinedEntity.text) && Objects.equals((Object)this.participant, (Object)ignoredMinedEntity.participant) && Objects.equals(this.dateCreated, ignoredMinedEntity.dateCreated) && Objects.equals(this.dateModified, ignoredMinedEntity.dateModified) && Objects.equals((Object)this.mediaType, (Object)ignoredMinedEntity.mediaType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.text, this.participant, this.dateCreated, this.dateModified, this.mediaType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IgnoredMinedEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    participant: ").append(this.toIndentedString((Object)this.participant)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ParticipantEnumDeserializer.class)
    public static enum ParticipantEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CUSTOMER("Customer"),
        AGENT("Agent"),
        BOTH("Both");

        private String value;

        private ParticipantEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ParticipantEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ParticipantEnum value : ParticipantEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ParticipantEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CHAT("Chat"),
        CALL("Call"),
        MESSAGE("Message"),
        EMAIL("Email");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ParticipantEnumDeserializer
    extends StdDeserializer<ParticipantEnum> {
        public ParticipantEnumDeserializer() {
            super(ParticipantEnumDeserializer.class);
        }

        public ParticipantEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ParticipantEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

