/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.WritableDivision;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the phone numbers, operating hours, and the Architect flows to execute for an IVR.")
public class IVR
implements Serializable {
    private String id = null;
    private String name = null;
    private WritableDivision division = null;
    private String description = null;
    private Integer version = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String modifiedBy = null;
    private String createdBy = null;
    private StateEnum state = null;
    private String modifiedByApp = null;
    private String createdByApp = null;
    private List<String> dnis = null;
    private DomainEntityRef openHoursFlow = null;
    private DomainEntityRef closedHoursFlow = null;
    private DomainEntityRef holidayHoursFlow = null;
    private DomainEntityRef scheduleGroup = null;
    private String selfUri = null;

    public IVR() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.dnis = new ArrayList<String>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public IVR name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the entity.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IVR division(WritableDivision division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division to which this entity belongs.")
    @JsonProperty(value="division")
    public WritableDivision getDivision() {
        return this.division;
    }

    public void setDivision(WritableDivision division) {
        this.division = division;
    }

    public IVR description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The resource's description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IVR version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The current version of the resource.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @ApiModelProperty(example="null", value="The date the resource was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The date of the last modification to the resource. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The ID of the user that last modified the resource.")
    @JsonProperty(value="modifiedBy")
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    @ApiModelProperty(example="null", value="The ID of the user that created the resource.")
    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(example="null", value="Indicates if the resource is active, inactive, or deleted.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    @ApiModelProperty(example="null", value="The application that last modified the resource.")
    @JsonProperty(value="modifiedByApp")
    public String getModifiedByApp() {
        return this.modifiedByApp;
    }

    @ApiModelProperty(example="null", value="The application that created the resource.")
    @JsonProperty(value="createdByApp")
    public String getCreatedByApp() {
        return this.createdByApp;
    }

    public IVR dnis(List<String> dnis) {
        this.dnis = dnis;
        return this;
    }

    @ApiModelProperty(example="null", value="The phone number(s) to contact the IVR by.  Each phone number must be unique and not in use by another resource.  For example, a user and an iVR cannot have the same phone number.")
    @JsonProperty(value="dnis")
    public List<String> getDnis() {
        return this.dnis;
    }

    public void setDnis(List<String> dnis) {
        this.dnis = dnis;
    }

    public IVR openHoursFlow(DomainEntityRef openHoursFlow) {
        this.openHoursFlow = openHoursFlow;
        return this;
    }

    @ApiModelProperty(example="null", value="The Architect flow to execute during the hours an organization is open.")
    @JsonProperty(value="openHoursFlow")
    public DomainEntityRef getOpenHoursFlow() {
        return this.openHoursFlow;
    }

    public void setOpenHoursFlow(DomainEntityRef openHoursFlow) {
        this.openHoursFlow = openHoursFlow;
    }

    public IVR closedHoursFlow(DomainEntityRef closedHoursFlow) {
        this.closedHoursFlow = closedHoursFlow;
        return this;
    }

    @ApiModelProperty(example="null", value="The Architect flow to execute during the hours an organization is closed.")
    @JsonProperty(value="closedHoursFlow")
    public DomainEntityRef getClosedHoursFlow() {
        return this.closedHoursFlow;
    }

    public void setClosedHoursFlow(DomainEntityRef closedHoursFlow) {
        this.closedHoursFlow = closedHoursFlow;
    }

    public IVR holidayHoursFlow(DomainEntityRef holidayHoursFlow) {
        this.holidayHoursFlow = holidayHoursFlow;
        return this;
    }

    @ApiModelProperty(example="null", value="The Architect flow to execute during an organization's holiday hours.")
    @JsonProperty(value="holidayHoursFlow")
    public DomainEntityRef getHolidayHoursFlow() {
        return this.holidayHoursFlow;
    }

    public void setHolidayHoursFlow(DomainEntityRef holidayHoursFlow) {
        this.holidayHoursFlow = holidayHoursFlow;
    }

    public IVR scheduleGroup(DomainEntityRef scheduleGroup) {
        this.scheduleGroup = scheduleGroup;
        return this;
    }

    @ApiModelProperty(example="null", value="The schedule group defining the open and closed hours for an organization.  If this is provided, an open flow and a closed flow must be specified as well.")
    @JsonProperty(value="scheduleGroup")
    public DomainEntityRef getScheduleGroup() {
        return this.scheduleGroup;
    }

    public void setScheduleGroup(DomainEntityRef scheduleGroup) {
        this.scheduleGroup = scheduleGroup;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IVR IVR2 = (IVR)o;
        return Objects.equals(this.id, IVR2.id) && Objects.equals(this.name, IVR2.name) && Objects.equals(this.division, IVR2.division) && Objects.equals(this.description, IVR2.description) && Objects.equals(this.version, IVR2.version) && Objects.equals(this.dateCreated, IVR2.dateCreated) && Objects.equals(this.dateModified, IVR2.dateModified) && Objects.equals(this.modifiedBy, IVR2.modifiedBy) && Objects.equals(this.createdBy, IVR2.createdBy) && Objects.equals((Object)this.state, (Object)IVR2.state) && Objects.equals(this.modifiedByApp, IVR2.modifiedByApp) && Objects.equals(this.createdByApp, IVR2.createdByApp) && Objects.equals(this.dnis, IVR2.dnis) && Objects.equals(this.openHoursFlow, IVR2.openHoursFlow) && Objects.equals(this.closedHoursFlow, IVR2.closedHoursFlow) && Objects.equals(this.holidayHoursFlow, IVR2.holidayHoursFlow) && Objects.equals(this.scheduleGroup, IVR2.scheduleGroup) && Objects.equals(this.selfUri, IVR2.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.division, this.description, this.version, this.dateCreated, this.dateModified, this.modifiedBy, this.createdBy, this.state, this.modifiedByApp, this.createdByApp, this.dnis, this.openHoursFlow, this.closedHoursFlow, this.holidayHoursFlow, this.scheduleGroup, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IVR {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    modifiedByApp: ").append(this.toIndentedString(this.modifiedByApp)).append("\n");
        sb.append("    createdByApp: ").append(this.toIndentedString(this.createdByApp)).append("\n");
        sb.append("    dnis: ").append(this.toIndentedString(this.dnis)).append("\n");
        sb.append("    openHoursFlow: ").append(this.toIndentedString(this.openHoursFlow)).append("\n");
        sb.append("    closedHoursFlow: ").append(this.toIndentedString(this.closedHoursFlow)).append("\n");
        sb.append("    holidayHoursFlow: ").append(this.toIndentedString(this.holidayHoursFlow)).append("\n");
        sb.append("    scheduleGroup: ").append(this.toIndentedString(this.scheduleGroup)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

