/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class ForecastMetadata
implements Serializable {
    private Date dateCreated = null;
    private String forecastId = null;
    private String intervalLengthInMinutes = null;
    private SourceEnum source = null;
    private Date dateStart = null;
    private String timeZone = null;

    public ForecastMetadata() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ForecastMetadata dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Forecast creation date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public ForecastMetadata forecastId(String forecastId) {
        this.forecastId = forecastId;
        return this;
    }

    @ApiModelProperty(example="null", value="Forecast ID")
    @JsonProperty(value="forecastId")
    public String getForecastId() {
        return this.forecastId;
    }

    public void setForecastId(String forecastId) {
        this.forecastId = forecastId;
    }

    public ForecastMetadata intervalLengthInMinutes(String intervalLengthInMinutes) {
        this.intervalLengthInMinutes = intervalLengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Interval length")
    @JsonProperty(value="intervalLengthInMinutes")
    public String getIntervalLengthInMinutes() {
        return this.intervalLengthInMinutes;
    }

    public void setIntervalLengthInMinutes(String intervalLengthInMinutes) {
        this.intervalLengthInMinutes = intervalLengthInMinutes;
    }

    public ForecastMetadata source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(example="null", value="Forecast source")
    @JsonProperty(value="source")
    public SourceEnum getSource() {
        return this.source;
    }

    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public ForecastMetadata dateStart(Date dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="null", value="Forecast start date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStart")
    public Date getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public ForecastMetadata timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", value="Timezone of the business unit")
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForecastMetadata forecastMetadata = (ForecastMetadata)o;
        return Objects.equals(this.dateCreated, forecastMetadata.dateCreated) && Objects.equals(this.forecastId, forecastMetadata.forecastId) && Objects.equals(this.intervalLengthInMinutes, forecastMetadata.intervalLengthInMinutes) && Objects.equals((Object)this.source, (Object)forecastMetadata.source) && Objects.equals(this.dateStart, forecastMetadata.dateStart) && Objects.equals(this.timeZone, forecastMetadata.timeZone);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateCreated, this.forecastId, this.intervalLengthInMinutes, this.source, this.dateStart, this.timeZone});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ForecastMetadata {\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    forecastId: ").append(this.toIndentedString(this.forecastId)).append("\n");
        sb.append("    intervalLengthInMinutes: ").append(this.toIndentedString(this.intervalLengthInMinutes)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SourceEnumDeserializer.class)
    public static enum SourceEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AUTOMATICBESTMETHOD("AutomaticBestMethod"),
        MAINFORECAST("MainForecast");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SourceEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SourceEnum value : SourceEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SourceEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SourceEnumDeserializer
    extends StdDeserializer<SourceEnum> {
        public SourceEnumDeserializer() {
            super(SourceEnumDeserializer.class);
        }

        public SourceEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SourceEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

