/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class DataIngestionRuleCriteria
implements Serializable {
    private EffectivePlatformEnum effectivePlatform = null;
    private String id = null;
    private String name = null;

    public DataIngestionRuleCriteria() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public DataIngestionRuleCriteria effectivePlatform(EffectivePlatformEnum effectivePlatform) {
        this.effectivePlatform = effectivePlatform;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The effective platform for the data ingestion rule.")
    @JsonProperty(value="effectivePlatform")
    public EffectivePlatformEnum getEffectivePlatform() {
        return this.effectivePlatform;
    }

    public void setEffectivePlatform(EffectivePlatformEnum effectivePlatform) {
        this.effectivePlatform = effectivePlatform;
    }

    public DataIngestionRuleCriteria id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the data ingestion rule.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(example="null", value="The name of the data ingestion rule. Only populated when expanded.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataIngestionRuleCriteria dataIngestionRuleCriteria = (DataIngestionRuleCriteria)o;
        return Objects.equals((Object)this.effectivePlatform, (Object)dataIngestionRuleCriteria.effectivePlatform) && Objects.equals(this.id, dataIngestionRuleCriteria.id) && Objects.equals(this.name, dataIngestionRuleCriteria.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.effectivePlatform, this.id, this.name});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataIngestionRuleCriteria {\n");
        sb.append("    effectivePlatform: ").append(this.toIndentedString((Object)this.effectivePlatform)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=EffectivePlatformEnumDeserializer.class)
    public static enum EffectivePlatformEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FACEBOOK("Facebook"),
        INSTAGRAM("Instagram"),
        TWITTER("Twitter"),
        OPEN("Open"),
        GOOGLEBUSINESSPROFILE("GoogleBusinessProfile");

        private String value;

        private EffectivePlatformEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EffectivePlatformEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EffectivePlatformEnum value : EffectivePlatformEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EffectivePlatformEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EffectivePlatformEnumDeserializer
    extends StdDeserializer<EffectivePlatformEnum> {
        public EffectivePlatformEnumDeserializer() {
            super(EffectivePlatformEnumDeserializer.class);
        }

        public EffectivePlatformEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EffectivePlatformEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

