/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class CreateTimeOffLimitRequest
implements Serializable {
    private GranularityEnum granularity = null;
    private Integer defaultLimitMinutes = null;

    public CreateTimeOffLimitRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public CreateTimeOffLimitRequest granularity(GranularityEnum granularity) {
        this.granularity = granularity;
        return this;
    }

    @ApiModelProperty(example="null", value="Granularity choice for time off limit. If not specified, 'Daily' is assumed")
    @JsonProperty(value="granularity")
    public GranularityEnum getGranularity() {
        return this.granularity;
    }

    public void setGranularity(GranularityEnum granularity) {
        this.granularity = granularity;
    }

    public CreateTimeOffLimitRequest defaultLimitMinutes(Integer defaultLimitMinutes) {
        this.defaultLimitMinutes = defaultLimitMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The default limit value in minutes per granularity. If not specified, then 0 is assumed, which means there are no time off minutes available")
    @JsonProperty(value="defaultLimitMinutes")
    public Integer getDefaultLimitMinutes() {
        return this.defaultLimitMinutes;
    }

    public void setDefaultLimitMinutes(Integer defaultLimitMinutes) {
        this.defaultLimitMinutes = defaultLimitMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTimeOffLimitRequest createTimeOffLimitRequest = (CreateTimeOffLimitRequest)o;
        return Objects.equals((Object)this.granularity, (Object)createTimeOffLimitRequest.granularity) && Objects.equals(this.defaultLimitMinutes, createTimeOffLimitRequest.defaultLimitMinutes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.granularity, this.defaultLimitMinutes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTimeOffLimitRequest {\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("    defaultLimitMinutes: ").append(this.toIndentedString(this.defaultLimitMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=GranularityEnumDeserializer.class)
    public static enum GranularityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAILY("Daily"),
        FIFTEENMINUTES("FifteenMinutes");

        private String value;

        private GranularityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GranularityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GranularityEnum value : GranularityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GranularityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GranularityEnumDeserializer
    extends StdDeserializer<GranularityEnum> {
        public GranularityEnumDeserializer() {
            super(GranularityEnumDeserializer.class);
        }

        public GranularityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GranularityEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

