/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ContestMetrics;
import com.mypurecloud.sdk.v2.model.ContestPrizes;
import com.mypurecloud.sdk.v2.model.WritableDivision;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ContestsCreateRequest
implements Serializable {
    private String id = null;
    private WritableDivision division = null;
    private String title = null;
    private String description = null;
    private LocalDate dateStart = null;
    private LocalDate dateEnd = null;
    private WinningCriteriaEnum winningCriteria = null;
    private Date dateAnnounced = null;
    private String announcementTimezone = null;
    private AnonymizationEnum anonymization = null;
    private List<ContestMetrics> metrics = null;
    private List<ContestPrizes> prizes = null;
    private String profileId = null;
    private List<String> participantIds = null;
    private String selfUri = null;

    public ContestsCreateRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.metrics = new ArrayList<ContestMetrics>();
            this.prizes = new ArrayList<ContestPrizes>();
            this.participantIds = new ArrayList<String>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ContestsCreateRequest division(WritableDivision division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division for this performance profile associate to. Only set for DEFAULT profile.")
    @JsonProperty(value="division")
    public WritableDivision getDivision() {
        return this.division;
    }

    public void setDivision(WritableDivision division) {
        this.division = division;
    }

    public ContestsCreateRequest title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest title")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ContestsCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest description")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ContestsCreateRequest dateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="Fri Jan 12 00:00:00 UTC 2024", required=true, value="Start date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateStart")
    public LocalDate getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
    }

    public ContestsCreateRequest dateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
        return this;
    }

    @ApiModelProperty(example="Fri Jan 12 00:00:00 UTC 2024", required=true, value="End date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEnd")
    public LocalDate getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
    }

    public ContestsCreateRequest winningCriteria(WinningCriteriaEnum winningCriteria) {
        this.winningCriteria = winningCriteria;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest winning criteria")
    @JsonProperty(value="winningCriteria")
    public WinningCriteriaEnum getWinningCriteria() {
        return this.winningCriteria;
    }

    public void setWinningCriteria(WinningCriteriaEnum winningCriteria) {
        this.winningCriteria = winningCriteria;
    }

    public ContestsCreateRequest dateAnnounced(Date dateAnnounced) {
        this.dateAnnounced = dateAnnounced;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest's Announcement Datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateAnnounced")
    public Date getDateAnnounced() {
        return this.dateAnnounced;
    }

    public void setDateAnnounced(Date dateAnnounced) {
        this.dateAnnounced = dateAnnounced;
    }

    public ContestsCreateRequest announcementTimezone(String announcementTimezone) {
        this.announcementTimezone = announcementTimezone;
        return this;
    }

    @ApiModelProperty(example="Europe/London", required=true, value="The Contest's Announcement Timezone. Valid values are strings of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London")
    @JsonProperty(value="announcementTimezone")
    public String getAnnouncementTimezone() {
        return this.announcementTimezone;
    }

    public void setAnnouncementTimezone(String announcementTimezone) {
        this.announcementTimezone = announcementTimezone;
    }

    public ContestsCreateRequest anonymization(AnonymizationEnum anonymization) {
        this.anonymization = anonymization;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest anonymization")
    @JsonProperty(value="anonymization")
    public AnonymizationEnum getAnonymization() {
        return this.anonymization;
    }

    public void setAnonymization(AnonymizationEnum anonymization) {
        this.anonymization = anonymization;
    }

    public ContestsCreateRequest metrics(List<ContestMetrics> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest's Metrics")
    @JsonProperty(value="metrics")
    public List<ContestMetrics> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<ContestMetrics> metrics) {
        this.metrics = metrics;
    }

    public ContestsCreateRequest prizes(List<ContestPrizes> prizes) {
        this.prizes = prizes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest Prizes")
    @JsonProperty(value="prizes")
    public List<ContestPrizes> getPrizes() {
        return this.prizes;
    }

    public void setPrizes(List<ContestPrizes> prizes) {
        this.prizes = prizes;
    }

    public ContestsCreateRequest profileId(String profileId) {
        this.profileId = profileId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest profile")
    @JsonProperty(value="profileId")
    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public ContestsCreateRequest participantIds(List<String> participantIds) {
        this.participantIds = participantIds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Contest's participants")
    @JsonProperty(value="participantIds")
    public List<String> getParticipantIds() {
        return this.participantIds;
    }

    public void setParticipantIds(List<String> participantIds) {
        this.participantIds = participantIds;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContestsCreateRequest contestsCreateRequest = (ContestsCreateRequest)o;
        return Objects.equals(this.id, contestsCreateRequest.id) && Objects.equals(this.division, contestsCreateRequest.division) && Objects.equals(this.title, contestsCreateRequest.title) && Objects.equals(this.description, contestsCreateRequest.description) && Objects.equals(this.dateStart, contestsCreateRequest.dateStart) && Objects.equals(this.dateEnd, contestsCreateRequest.dateEnd) && Objects.equals((Object)this.winningCriteria, (Object)contestsCreateRequest.winningCriteria) && Objects.equals(this.dateAnnounced, contestsCreateRequest.dateAnnounced) && Objects.equals(this.announcementTimezone, contestsCreateRequest.announcementTimezone) && Objects.equals((Object)this.anonymization, (Object)contestsCreateRequest.anonymization) && Objects.equals(this.metrics, contestsCreateRequest.metrics) && Objects.equals(this.prizes, contestsCreateRequest.prizes) && Objects.equals(this.profileId, contestsCreateRequest.profileId) && Objects.equals(this.participantIds, contestsCreateRequest.participantIds) && Objects.equals(this.selfUri, contestsCreateRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.division, this.title, this.description, this.dateStart, this.dateEnd, this.winningCriteria, this.dateAnnounced, this.announcementTimezone, this.anonymization, this.metrics, this.prizes, this.profileId, this.participantIds, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContestsCreateRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    dateEnd: ").append(this.toIndentedString(this.dateEnd)).append("\n");
        sb.append("    winningCriteria: ").append(this.toIndentedString((Object)this.winningCriteria)).append("\n");
        sb.append("    dateAnnounced: ").append(this.toIndentedString(this.dateAnnounced)).append("\n");
        sb.append("    announcementTimezone: ").append(this.toIndentedString(this.announcementTimezone)).append("\n");
        sb.append("    anonymization: ").append(this.toIndentedString((Object)this.anonymization)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    prizes: ").append(this.toIndentedString(this.prizes)).append("\n");
        sb.append("    profileId: ").append(this.toIndentedString(this.profileId)).append("\n");
        sb.append("    participantIds: ").append(this.toIndentedString(this.participantIds)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=WinningCriteriaEnumDeserializer.class)
    public static enum WinningCriteriaEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HIGHESTOVERALLSCORE("HighestOverallScore"),
        HIGHESTOVERALLPERCENTOFGOAL("HighestOverallPercentOfGoal");

        private String value;

        private WinningCriteriaEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static WinningCriteriaEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (WinningCriteriaEnum value : WinningCriteriaEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return WinningCriteriaEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=AnonymizationEnumDeserializer.class)
    public static enum AnonymizationEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NOANONYMIZATION("NoAnonymization"),
        ALL("All"),
        ALLEXCEPTTOP("AllExceptTop");

        private String value;

        private AnonymizationEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AnonymizationEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AnonymizationEnum value : AnonymizationEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AnonymizationEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AnonymizationEnumDeserializer
    extends StdDeserializer<AnonymizationEnum> {
        public AnonymizationEnumDeserializer() {
            super(AnonymizationEnumDeserializer.class);
        }

        public AnonymizationEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AnonymizationEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class WinningCriteriaEnumDeserializer
    extends StdDeserializer<WinningCriteriaEnum> {
        public WinningCriteriaEnumDeserializer() {
            super(WinningCriteriaEnumDeserializer.class);
        }

        public WinningCriteriaEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return WinningCriteriaEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

