/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ActivityCodesReference;
import com.mypurecloud.sdk.v2.model.BuTimeOffLimitReference;
import com.mypurecloud.sdk.v2.model.HrisTimeOffType;
import com.mypurecloud.sdk.v2.model.TimeOffPlanBusinessUnitAssociation;
import com.mypurecloud.sdk.v2.model.TimeOffPlanManagementUnitAssociation;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BuTimeOffPlanResponse
implements Serializable {
    private String id = null;
    private String name = null;
    private List<String> activityCodeIds = null;
    private List<BuTimeOffLimitReference> timeOffLimits = null;
    private AutoApprovalRuleEnum autoApprovalRule = null;
    private Integer daysBeforeStartToExpireFromWaitlist = null;
    private Boolean autoPublishApprovedTimeOffRequests = null;
    private ActivityCodesReference restrictedActivityCodes = null;
    private HrisTimeOffType hrisTimeOffType = null;
    private Boolean enabled = null;
    private Boolean countAgainstTimeOffLimits = null;
    private TimeOffPlanBusinessUnitAssociation businessUnitAssociation = null;
    private TimeOffPlanManagementUnitAssociation managementUnitAssociation = null;
    private WfmVersionedEntityMetadata metadata = null;
    private String selfUri = null;

    public BuTimeOffPlanResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.activityCodeIds = new ArrayList<String>();
            this.timeOffLimits = new ArrayList<BuTimeOffLimitReference>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public BuTimeOffPlanResponse name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of this time-off plan")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BuTimeOffPlanResponse activityCodeIds(List<String> activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The IDs of activity codes associated with this time-off plan")
    @JsonProperty(value="activityCodeIds")
    public List<String> getActivityCodeIds() {
        return this.activityCodeIds;
    }

    public void setActivityCodeIds(List<String> activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
    }

    public BuTimeOffPlanResponse timeOffLimits(List<BuTimeOffLimitReference> timeOffLimits) {
        this.timeOffLimits = timeOffLimits;
        return this;
    }

    @ApiModelProperty(example="null", value="The IDs of time-off limits associated with this time-off plan")
    @JsonProperty(value="timeOffLimits")
    public List<BuTimeOffLimitReference> getTimeOffLimits() {
        return this.timeOffLimits;
    }

    public void setTimeOffLimits(List<BuTimeOffLimitReference> timeOffLimits) {
        this.timeOffLimits = timeOffLimits;
    }

    public BuTimeOffPlanResponse autoApprovalRule(AutoApprovalRuleEnum autoApprovalRule) {
        this.autoApprovalRule = autoApprovalRule;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Auto approval rule for this time-off plan")
    @JsonProperty(value="autoApprovalRule")
    public AutoApprovalRuleEnum getAutoApprovalRule() {
        return this.autoApprovalRule;
    }

    public void setAutoApprovalRule(AutoApprovalRuleEnum autoApprovalRule) {
        this.autoApprovalRule = autoApprovalRule;
    }

    public BuTimeOffPlanResponse daysBeforeStartToExpireFromWaitlist(Integer daysBeforeStartToExpireFromWaitlist) {
        this.daysBeforeStartToExpireFromWaitlist = daysBeforeStartToExpireFromWaitlist;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The number of days before the time-off request start date for when the request will be expired from the waitlist")
    @JsonProperty(value="daysBeforeStartToExpireFromWaitlist")
    public Integer getDaysBeforeStartToExpireFromWaitlist() {
        return this.daysBeforeStartToExpireFromWaitlist;
    }

    public void setDaysBeforeStartToExpireFromWaitlist(Integer daysBeforeStartToExpireFromWaitlist) {
        this.daysBeforeStartToExpireFromWaitlist = daysBeforeStartToExpireFromWaitlist;
    }

    public BuTimeOffPlanResponse autoPublishApprovedTimeOffRequests(Boolean autoPublishApprovedTimeOffRequests) {
        this.autoPublishApprovedTimeOffRequests = autoPublishApprovedTimeOffRequests;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether newly approved time-off requests with activity codes associated with this time-off plan should be automatically published to the schedule")
    @JsonProperty(value="autoPublishApprovedTimeOffRequests")
    public Boolean getAutoPublishApprovedTimeOffRequests() {
        return this.autoPublishApprovedTimeOffRequests;
    }

    public void setAutoPublishApprovedTimeOffRequests(Boolean autoPublishApprovedTimeOffRequests) {
        this.autoPublishApprovedTimeOffRequests = autoPublishApprovedTimeOffRequests;
    }

    public BuTimeOffPlanResponse restrictedActivityCodes(ActivityCodesReference restrictedActivityCodes) {
        this.restrictedActivityCodes = restrictedActivityCodes;
        return this;
    }

    @ApiModelProperty(example="null", value="The IDs of non time-off activity codes to check for conflicts in case the auto approval rule specifies checking activity codes. If these activity codes are present in schedule and overlap with the time-off request duration, the request will not be auto approved")
    @JsonProperty(value="restrictedActivityCodes")
    public ActivityCodesReference getRestrictedActivityCodes() {
        return this.restrictedActivityCodes;
    }

    public void setRestrictedActivityCodes(ActivityCodesReference restrictedActivityCodes) {
        this.restrictedActivityCodes = restrictedActivityCodes;
    }

    public BuTimeOffPlanResponse hrisTimeOffType(HrisTimeOffType hrisTimeOffType) {
        this.hrisTimeOffType = hrisTimeOffType;
        return this;
    }

    @ApiModelProperty(example="null", value="Time-off type, if this time-off plan is associated with the integration")
    @JsonProperty(value="hrisTimeOffType")
    public HrisTimeOffType getHrisTimeOffType() {
        return this.hrisTimeOffType;
    }

    public void setHrisTimeOffType(HrisTimeOffType hrisTimeOffType) {
        this.hrisTimeOffType = hrisTimeOffType;
    }

    public BuTimeOffPlanResponse enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether this time-off plan is currently being used by agents")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public BuTimeOffPlanResponse countAgainstTimeOffLimits(Boolean countAgainstTimeOffLimits) {
        this.countAgainstTimeOffLimits = countAgainstTimeOffLimits;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether this time-off plan counts against time-off limits")
    @JsonProperty(value="countAgainstTimeOffLimits")
    public Boolean getCountAgainstTimeOffLimits() {
        return this.countAgainstTimeOffLimits;
    }

    public void setCountAgainstTimeOffLimits(Boolean countAgainstTimeOffLimits) {
        this.countAgainstTimeOffLimits = countAgainstTimeOffLimits;
    }

    public BuTimeOffPlanResponse businessUnitAssociation(TimeOffPlanBusinessUnitAssociation businessUnitAssociation) {
        this.businessUnitAssociation = businessUnitAssociation;
        return this;
    }

    @ApiModelProperty(example="null", value="Business unit association, if the time-off plan belongs to a business unit. managementUnitAssociation must not be set if this is populated")
    @JsonProperty(value="businessUnitAssociation")
    public TimeOffPlanBusinessUnitAssociation getBusinessUnitAssociation() {
        return this.businessUnitAssociation;
    }

    public void setBusinessUnitAssociation(TimeOffPlanBusinessUnitAssociation businessUnitAssociation) {
        this.businessUnitAssociation = businessUnitAssociation;
    }

    public BuTimeOffPlanResponse managementUnitAssociation(TimeOffPlanManagementUnitAssociation managementUnitAssociation) {
        this.managementUnitAssociation = managementUnitAssociation;
        return this;
    }

    @ApiModelProperty(example="null", value="Management Unit association, if the time-off plan belongs to a management unit. businessUnitAssociation must not be set if this is populated")
    @JsonProperty(value="managementUnitAssociation")
    public TimeOffPlanManagementUnitAssociation getManagementUnitAssociation() {
        return this.managementUnitAssociation;
    }

    public void setManagementUnitAssociation(TimeOffPlanManagementUnitAssociation managementUnitAssociation) {
        this.managementUnitAssociation = managementUnitAssociation;
    }

    public BuTimeOffPlanResponse metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version metadata for the time-off plan")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuTimeOffPlanResponse buTimeOffPlanResponse = (BuTimeOffPlanResponse)o;
        return Objects.equals(this.id, buTimeOffPlanResponse.id) && Objects.equals(this.name, buTimeOffPlanResponse.name) && Objects.equals(this.activityCodeIds, buTimeOffPlanResponse.activityCodeIds) && Objects.equals(this.timeOffLimits, buTimeOffPlanResponse.timeOffLimits) && Objects.equals((Object)this.autoApprovalRule, (Object)buTimeOffPlanResponse.autoApprovalRule) && Objects.equals(this.daysBeforeStartToExpireFromWaitlist, buTimeOffPlanResponse.daysBeforeStartToExpireFromWaitlist) && Objects.equals(this.autoPublishApprovedTimeOffRequests, buTimeOffPlanResponse.autoPublishApprovedTimeOffRequests) && Objects.equals(this.restrictedActivityCodes, buTimeOffPlanResponse.restrictedActivityCodes) && Objects.equals(this.hrisTimeOffType, buTimeOffPlanResponse.hrisTimeOffType) && Objects.equals(this.enabled, buTimeOffPlanResponse.enabled) && Objects.equals(this.countAgainstTimeOffLimits, buTimeOffPlanResponse.countAgainstTimeOffLimits) && Objects.equals(this.businessUnitAssociation, buTimeOffPlanResponse.businessUnitAssociation) && Objects.equals(this.managementUnitAssociation, buTimeOffPlanResponse.managementUnitAssociation) && Objects.equals(this.metadata, buTimeOffPlanResponse.metadata) && Objects.equals(this.selfUri, buTimeOffPlanResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.activityCodeIds, this.timeOffLimits, this.autoApprovalRule, this.daysBeforeStartToExpireFromWaitlist, this.autoPublishApprovedTimeOffRequests, this.restrictedActivityCodes, this.hrisTimeOffType, this.enabled, this.countAgainstTimeOffLimits, this.businessUnitAssociation, this.managementUnitAssociation, this.metadata, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuTimeOffPlanResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    activityCodeIds: ").append(this.toIndentedString(this.activityCodeIds)).append("\n");
        sb.append("    timeOffLimits: ").append(this.toIndentedString(this.timeOffLimits)).append("\n");
        sb.append("    autoApprovalRule: ").append(this.toIndentedString((Object)this.autoApprovalRule)).append("\n");
        sb.append("    daysBeforeStartToExpireFromWaitlist: ").append(this.toIndentedString(this.daysBeforeStartToExpireFromWaitlist)).append("\n");
        sb.append("    autoPublishApprovedTimeOffRequests: ").append(this.toIndentedString(this.autoPublishApprovedTimeOffRequests)).append("\n");
        sb.append("    restrictedActivityCodes: ").append(this.toIndentedString(this.restrictedActivityCodes)).append("\n");
        sb.append("    hrisTimeOffType: ").append(this.toIndentedString(this.hrisTimeOffType)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    countAgainstTimeOffLimits: ").append(this.toIndentedString(this.countAgainstTimeOffLimits)).append("\n");
        sb.append("    businessUnitAssociation: ").append(this.toIndentedString(this.businessUnitAssociation)).append("\n");
        sb.append("    managementUnitAssociation: ").append(this.toIndentedString(this.managementUnitAssociation)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AutoApprovalRuleEnumDeserializer.class)
    public static enum AutoApprovalRuleEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NEVER("Never"),
        ALWAYS("Always"),
        CHECKLIMITS("CheckLimits"),
        CHECKACTIVITYCODES("CheckActivityCodes"),
        CHECKLIMITSANDACTIVITYCODES("CheckLimitsAndActivityCodes");

        private String value;

        private AutoApprovalRuleEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AutoApprovalRuleEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AutoApprovalRuleEnum value : AutoApprovalRuleEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AutoApprovalRuleEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AutoApprovalRuleEnumDeserializer
    extends StdDeserializer<AutoApprovalRuleEnum> {
        public AutoApprovalRuleEnumDeserializer() {
            super(AutoApprovalRuleEnumDeserializer.class);
        }

        public AutoApprovalRuleEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AutoApprovalRuleEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

