/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.BillingContractPeriod;
import com.mypurecloud.sdk.v2.model.BillingPlan;
import com.mypurecloud.sdk.v2.model.Customer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BillingContract
implements Serializable {
    private String id = null;
    private String externalNumber = null;
    private StatusEnum status = null;
    private String commercialModel = null;
    private List<String> purchaseOrderNumbers = null;
    private Customer billToCustomer = null;
    private Customer soldToCustomer = null;
    private Customer endCustomer = null;
    private LocalDate dateStart = null;
    private LocalDate dateEnd = null;
    private LocalDate dateRampStart = null;
    private LocalDate dateRampEnd = null;
    private List<BillingContractPeriod> billingPeriods = null;
    private List<BillingPlan> plans = null;

    public BillingContract() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.purchaseOrderNumbers = new ArrayList<String>();
            this.billingPeriods = new ArrayList<BillingContractPeriod>();
            this.plans = new ArrayList<BillingPlan>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public BillingContract externalNumber(String externalNumber) {
        this.externalNumber = externalNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique external number.")
    @JsonProperty(value="externalNumber")
    public String getExternalNumber() {
        return this.externalNumber;
    }

    public void setExternalNumber(String externalNumber) {
        this.externalNumber = externalNumber;
    }

    public BillingContract status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the contract.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public BillingContract commercialModel(String commercialModel) {
        this.commercialModel = commercialModel;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of commercial model.")
    @JsonProperty(value="commercialModel")
    public String getCommercialModel() {
        return this.commercialModel;
    }

    public void setCommercialModel(String commercialModel) {
        this.commercialModel = commercialModel;
    }

    public BillingContract purchaseOrderNumbers(List<String> purchaseOrderNumbers) {
        this.purchaseOrderNumbers = purchaseOrderNumbers;
        return this;
    }

    @ApiModelProperty(example="null", value="List of po numbers periods for this contract.")
    @JsonProperty(value="purchaseOrderNumbers")
    public List<String> getPurchaseOrderNumbers() {
        return this.purchaseOrderNumbers;
    }

    public void setPurchaseOrderNumbers(List<String> purchaseOrderNumbers) {
        this.purchaseOrderNumbers = purchaseOrderNumbers;
    }

    public BillingContract billToCustomer(Customer billToCustomer) {
        this.billToCustomer = billToCustomer;
        return this;
    }

    @ApiModelProperty(example="null", value="The bill to customer.")
    @JsonProperty(value="billToCustomer")
    public Customer getBillToCustomer() {
        return this.billToCustomer;
    }

    public void setBillToCustomer(Customer billToCustomer) {
        this.billToCustomer = billToCustomer;
    }

    public BillingContract soldToCustomer(Customer soldToCustomer) {
        this.soldToCustomer = soldToCustomer;
        return this;
    }

    @ApiModelProperty(example="null", value="The sold to customer.")
    @JsonProperty(value="soldToCustomer")
    public Customer getSoldToCustomer() {
        return this.soldToCustomer;
    }

    public void setSoldToCustomer(Customer soldToCustomer) {
        this.soldToCustomer = soldToCustomer;
    }

    public BillingContract endCustomer(Customer endCustomer) {
        this.endCustomer = endCustomer;
        return this;
    }

    @ApiModelProperty(example="null", value="The end customer.")
    @JsonProperty(value="endCustomer")
    public Customer getEndCustomer() {
        return this.endCustomer;
    }

    public void setEndCustomer(Customer endCustomer) {
        this.endCustomer = endCustomer;
    }

    public BillingContract dateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="null", value="The start date of the contract. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateStart")
    public LocalDate getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(LocalDate dateStart) {
        this.dateStart = dateStart;
    }

    public BillingContract dateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="The end date of the contract. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEnd")
    public LocalDate getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
    }

    public BillingContract dateRampStart(LocalDate dateRampStart) {
        this.dateRampStart = dateRampStart;
        return this;
    }

    @ApiModelProperty(example="null", value="the date when the first revenue or quantity in a ramped deal begins. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateRampStart")
    public LocalDate getDateRampStart() {
        return this.dateRampStart;
    }

    public void setDateRampStart(LocalDate dateRampStart) {
        this.dateRampStart = dateRampStart;
    }

    public BillingContract dateRampEnd(LocalDate dateRampEnd) {
        this.dateRampEnd = dateRampEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="the date when the first revenue or quantity in a ramped deal ends. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateRampEnd")
    public LocalDate getDateRampEnd() {
        return this.dateRampEnd;
    }

    public void setDateRampEnd(LocalDate dateRampEnd) {
        this.dateRampEnd = dateRampEnd;
    }

    public BillingContract billingPeriods(List<BillingContractPeriod> billingPeriods) {
        this.billingPeriods = billingPeriods;
        return this;
    }

    @ApiModelProperty(example="null", value="List of billing periods for the contract.")
    @JsonProperty(value="billingPeriods")
    public List<BillingContractPeriod> getBillingPeriods() {
        return this.billingPeriods;
    }

    public void setBillingPeriods(List<BillingContractPeriod> billingPeriods) {
        this.billingPeriods = billingPeriods;
    }

    public BillingContract plans(List<BillingPlan> plans) {
        this.plans = plans;
        return this;
    }

    @ApiModelProperty(example="null", value="The collection of prices for the related organizations.")
    @JsonProperty(value="plans")
    public List<BillingPlan> getPlans() {
        return this.plans;
    }

    public void setPlans(List<BillingPlan> plans) {
        this.plans = plans;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingContract billingContract = (BillingContract)o;
        return Objects.equals(this.id, billingContract.id) && Objects.equals(this.externalNumber, billingContract.externalNumber) && Objects.equals((Object)this.status, (Object)billingContract.status) && Objects.equals(this.commercialModel, billingContract.commercialModel) && Objects.equals(this.purchaseOrderNumbers, billingContract.purchaseOrderNumbers) && Objects.equals(this.billToCustomer, billingContract.billToCustomer) && Objects.equals(this.soldToCustomer, billingContract.soldToCustomer) && Objects.equals(this.endCustomer, billingContract.endCustomer) && Objects.equals(this.dateStart, billingContract.dateStart) && Objects.equals(this.dateEnd, billingContract.dateEnd) && Objects.equals(this.dateRampStart, billingContract.dateRampStart) && Objects.equals(this.dateRampEnd, billingContract.dateRampEnd) && Objects.equals(this.billingPeriods, billingContract.billingPeriods) && Objects.equals(this.plans, billingContract.plans);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.externalNumber, this.status, this.commercialModel, this.purchaseOrderNumbers, this.billToCustomer, this.soldToCustomer, this.endCustomer, this.dateStart, this.dateEnd, this.dateRampStart, this.dateRampEnd, this.billingPeriods, this.plans});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingContract {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    externalNumber: ").append(this.toIndentedString(this.externalNumber)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    commercialModel: ").append(this.toIndentedString(this.commercialModel)).append("\n");
        sb.append("    purchaseOrderNumbers: ").append(this.toIndentedString(this.purchaseOrderNumbers)).append("\n");
        sb.append("    billToCustomer: ").append(this.toIndentedString(this.billToCustomer)).append("\n");
        sb.append("    soldToCustomer: ").append(this.toIndentedString(this.soldToCustomer)).append("\n");
        sb.append("    endCustomer: ").append(this.toIndentedString(this.endCustomer)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    dateEnd: ").append(this.toIndentedString(this.dateEnd)).append("\n");
        sb.append("    dateRampStart: ").append(this.toIndentedString(this.dateRampStart)).append("\n");
        sb.append("    dateRampEnd: ").append(this.toIndentedString(this.dateRampEnd)).append("\n");
        sb.append("    billingPeriods: ").append(this.toIndentedString(this.billingPeriods)).append("\n");
        sb.append("    plans: ").append(this.toIndentedString(this.plans)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("Active"),
        INACTIVE("Inactive");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

