/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.BackgroundImageSettings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="The settings for Agent Video")
public class AgentVideoSettings
implements Serializable {
    private Boolean allowCamera = null;
    private Boolean allowScreenShare = null;
    private Boolean allowMicrophone = null;
    private BackgroundEnum background = null;
    private BackgroundImageSettings backgroundImage = null;

    public AgentVideoSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public AgentVideoSettings allowCamera(Boolean allowCamera) {
        this.allowCamera = allowCamera;
        return this;
    }

    @ApiModelProperty(example="null", value="whether or not agent camera is allowed")
    @JsonProperty(value="allowCamera")
    public Boolean getAllowCamera() {
        return this.allowCamera;
    }

    public void setAllowCamera(Boolean allowCamera) {
        this.allowCamera = allowCamera;
    }

    public AgentVideoSettings allowScreenShare(Boolean allowScreenShare) {
        this.allowScreenShare = allowScreenShare;
        return this;
    }

    @ApiModelProperty(example="null", value="whether or not agent screen share is allowed")
    @JsonProperty(value="allowScreenShare")
    public Boolean getAllowScreenShare() {
        return this.allowScreenShare;
    }

    public void setAllowScreenShare(Boolean allowScreenShare) {
        this.allowScreenShare = allowScreenShare;
    }

    public AgentVideoSettings allowMicrophone(Boolean allowMicrophone) {
        this.allowMicrophone = allowMicrophone;
        return this;
    }

    @ApiModelProperty(example="null", value="whether or not agent microphone is allowed")
    @JsonProperty(value="allowMicrophone")
    public Boolean getAllowMicrophone() {
        return this.allowMicrophone;
    }

    public void setAllowMicrophone(Boolean allowMicrophone) {
        this.allowMicrophone = allowMicrophone;
    }

    public AgentVideoSettings background(BackgroundEnum background) {
        this.background = background;
        return this;
    }

    @ApiModelProperty(example="null", value="background for agent")
    @JsonProperty(value="background")
    public BackgroundEnum getBackground() {
        return this.background;
    }

    public void setBackground(BackgroundEnum background) {
        this.background = background;
    }

    public AgentVideoSettings backgroundImage(BackgroundImageSettings backgroundImage) {
        this.backgroundImage = backgroundImage;
        return this;
    }

    @ApiModelProperty(example="null", value="background image settings for agent")
    @JsonProperty(value="backgroundImage")
    public BackgroundImageSettings getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(BackgroundImageSettings backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentVideoSettings agentVideoSettings = (AgentVideoSettings)o;
        return Objects.equals(this.allowCamera, agentVideoSettings.allowCamera) && Objects.equals(this.allowScreenShare, agentVideoSettings.allowScreenShare) && Objects.equals(this.allowMicrophone, agentVideoSettings.allowMicrophone) && Objects.equals((Object)this.background, (Object)agentVideoSettings.background) && Objects.equals(this.backgroundImage, agentVideoSettings.backgroundImage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowCamera, this.allowScreenShare, this.allowMicrophone, this.background, this.backgroundImage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentVideoSettings {\n");
        sb.append("    allowCamera: ").append(this.toIndentedString(this.allowCamera)).append("\n");
        sb.append("    allowScreenShare: ").append(this.toIndentedString(this.allowScreenShare)).append("\n");
        sb.append("    allowMicrophone: ").append(this.toIndentedString(this.allowMicrophone)).append("\n");
        sb.append("    background: ").append(this.toIndentedString((Object)this.background)).append("\n");
        sb.append("    backgroundImage: ").append(this.toIndentedString(this.backgroundImage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=BackgroundEnumDeserializer.class)
    public static enum BackgroundEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BLUR("BLUR"),
        NONE("NONE"),
        IMAGE("IMAGE");

        private String value;

        private BackgroundEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static BackgroundEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (BackgroundEnum value : BackgroundEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return BackgroundEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class BackgroundEnumDeserializer
    extends StdDeserializer<BackgroundEnum> {
        public BackgroundEnumDeserializer() {
            super(BackgroundEnumDeserializer.class);
        }

        public BackgroundEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return BackgroundEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

