/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ActivationTrigger;
import com.mypurecloud.sdk.v2.model.ChecklistItem;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AgentChecklistResponse
implements Serializable {
    private String id = null;
    private String name = null;
    private List<ChecklistItem> checklistItems = null;
    private List<ActivationTrigger> activationTriggers = null;
    private StatusEnum status = null;
    private String exitReason = null;
    private String language = null;
    private String agentId = null;
    private String participantId = null;
    private String queueId = null;
    private String assistantId = null;
    private MediaTypeEnum mediaType = null;
    private DirectionEnum direction = null;
    private Date evaluationStartDate = null;
    private Date evaluationLastModifiedDate = null;
    private Date evaluationFinalizedDate = null;
    private Date evaluationFinalizedWithAcwDate = null;
    private String selfUri = null;

    public AgentChecklistResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.checklistItems = new ArrayList<ChecklistItem>();
            this.activationTriggers = new ArrayList<ActivationTrigger>();
        }
    }

    public AgentChecklistResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the checklist.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AgentChecklistResponse name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the checklist.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AgentChecklistResponse checklistItems(List<ChecklistItem> checklistItems) {
        this.checklistItems = checklistItems;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="List of individual Checklist Items.")
    @JsonProperty(value="checklistItems")
    public List<ChecklistItem> getChecklistItems() {
        return this.checklistItems;
    }

    public void setChecklistItems(List<ChecklistItem> checklistItems) {
        this.checklistItems = checklistItems;
    }

    public AgentChecklistResponse activationTriggers(List<ActivationTrigger> activationTriggers) {
        this.activationTriggers = activationTriggers;
        return this;
    }

    @ApiModelProperty(example="null", value="List of triggers that activated this checklist.")
    @JsonProperty(value="activationTriggers")
    public List<ActivationTrigger> getActivationTriggers() {
        return this.activationTriggers;
    }

    public void setActivationTriggers(List<ActivationTrigger> activationTriggers) {
        this.activationTriggers = activationTriggers;
    }

    public AgentChecklistResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The evaluation status of the checklist.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AgentChecklistResponse exitReason(String exitReason) {
        this.exitReason = exitReason;
        return this;
    }

    @ApiModelProperty(example="null", value="Exit reason provided at the time of finalizing the checklist.")
    @JsonProperty(value="exitReason")
    public String getExitReason() {
        return this.exitReason;
    }

    public void setExitReason(String exitReason) {
        this.exitReason = exitReason;
    }

    public AgentChecklistResponse language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Language associated with the checklist.")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public AgentChecklistResponse agentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    @ApiModelProperty(example="null", value="Agent ID.")
    @JsonProperty(value="agentId")
    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public AgentChecklistResponse participantId(String participantId) {
        this.participantId = participantId;
        return this;
    }

    @ApiModelProperty(example="null", value="Participant ID.")
    @JsonProperty(value="participantId")
    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public AgentChecklistResponse queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="Queue ID.")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public AgentChecklistResponse assistantId(String assistantId) {
        this.assistantId = assistantId;
        return this;
    }

    @ApiModelProperty(example="null", value="Assistant ID.")
    @JsonProperty(value="assistantId")
    public String getAssistantId() {
        return this.assistantId;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public AgentChecklistResponse mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="Media type.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public AgentChecklistResponse direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="Direction of the conversation.")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public AgentChecklistResponse evaluationStartDate(Date evaluationStartDate) {
        this.evaluationStartDate = evaluationStartDate;
        return this;
    }

    @ApiModelProperty(example="2025-08-06T03:52:10.150Z", value="Date when the checklist evaluation began. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="evaluationStartDate")
    public Date getEvaluationStartDate() {
        return this.evaluationStartDate;
    }

    public void setEvaluationStartDate(Date evaluationStartDate) {
        this.evaluationStartDate = evaluationStartDate;
    }

    public AgentChecklistResponse evaluationLastModifiedDate(Date evaluationLastModifiedDate) {
        this.evaluationLastModifiedDate = evaluationLastModifiedDate;
        return this;
    }

    @ApiModelProperty(example="2025-08-06T03:52:10.150Z", value="Date when the checklist was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="evaluationLastModifiedDate")
    public Date getEvaluationLastModifiedDate() {
        return this.evaluationLastModifiedDate;
    }

    public void setEvaluationLastModifiedDate(Date evaluationLastModifiedDate) {
        this.evaluationLastModifiedDate = evaluationLastModifiedDate;
    }

    public AgentChecklistResponse evaluationFinalizedDate(Date evaluationFinalizedDate) {
        this.evaluationFinalizedDate = evaluationFinalizedDate;
        return this;
    }

    @ApiModelProperty(example="2025-08-06T03:52:10.150Z", value="Date when the checklist was finalized. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="evaluationFinalizedDate")
    public Date getEvaluationFinalizedDate() {
        return this.evaluationFinalizedDate;
    }

    public void setEvaluationFinalizedDate(Date evaluationFinalizedDate) {
        this.evaluationFinalizedDate = evaluationFinalizedDate;
    }

    public AgentChecklistResponse evaluationFinalizedWithAcwDate(Date evaluationFinalizedWithAcwDate) {
        this.evaluationFinalizedWithAcwDate = evaluationFinalizedWithAcwDate;
        return this;
    }

    @ApiModelProperty(example="2025-08-06T03:52:10.150Z", value="Date when the checklist was finalized with ACW. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="evaluationFinalizedWithAcwDate")
    public Date getEvaluationFinalizedWithAcwDate() {
        return this.evaluationFinalizedWithAcwDate;
    }

    public void setEvaluationFinalizedWithAcwDate(Date evaluationFinalizedWithAcwDate) {
        this.evaluationFinalizedWithAcwDate = evaluationFinalizedWithAcwDate;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentChecklistResponse agentChecklistResponse = (AgentChecklistResponse)o;
        return Objects.equals(this.id, agentChecklistResponse.id) && Objects.equals(this.name, agentChecklistResponse.name) && Objects.equals(this.checklistItems, agentChecklistResponse.checklistItems) && Objects.equals(this.activationTriggers, agentChecklistResponse.activationTriggers) && Objects.equals((Object)this.status, (Object)agentChecklistResponse.status) && Objects.equals(this.exitReason, agentChecklistResponse.exitReason) && Objects.equals(this.language, agentChecklistResponse.language) && Objects.equals(this.agentId, agentChecklistResponse.agentId) && Objects.equals(this.participantId, agentChecklistResponse.participantId) && Objects.equals(this.queueId, agentChecklistResponse.queueId) && Objects.equals(this.assistantId, agentChecklistResponse.assistantId) && Objects.equals((Object)this.mediaType, (Object)agentChecklistResponse.mediaType) && Objects.equals((Object)this.direction, (Object)agentChecklistResponse.direction) && Objects.equals(this.evaluationStartDate, agentChecklistResponse.evaluationStartDate) && Objects.equals(this.evaluationLastModifiedDate, agentChecklistResponse.evaluationLastModifiedDate) && Objects.equals(this.evaluationFinalizedDate, agentChecklistResponse.evaluationFinalizedDate) && Objects.equals(this.evaluationFinalizedWithAcwDate, agentChecklistResponse.evaluationFinalizedWithAcwDate) && Objects.equals(this.selfUri, agentChecklistResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.checklistItems, this.activationTriggers, this.status, this.exitReason, this.language, this.agentId, this.participantId, this.queueId, this.assistantId, this.mediaType, this.direction, this.evaluationStartDate, this.evaluationLastModifiedDate, this.evaluationFinalizedDate, this.evaluationFinalizedWithAcwDate, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentChecklistResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    checklistItems: ").append(this.toIndentedString(this.checklistItems)).append("\n");
        sb.append("    activationTriggers: ").append(this.toIndentedString(this.activationTriggers)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    exitReason: ").append(this.toIndentedString(this.exitReason)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    agentId: ").append(this.toIndentedString(this.agentId)).append("\n");
        sb.append("    participantId: ").append(this.toIndentedString(this.participantId)).append("\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    assistantId: ").append(this.toIndentedString(this.assistantId)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    evaluationStartDate: ").append(this.toIndentedString(this.evaluationStartDate)).append("\n");
        sb.append("    evaluationLastModifiedDate: ").append(this.toIndentedString(this.evaluationLastModifiedDate)).append("\n");
        sb.append("    evaluationFinalizedDate: ").append(this.toIndentedString(this.evaluationFinalizedDate)).append("\n");
        sb.append("    evaluationFinalizedWithAcwDate: ").append(this.toIndentedString(this.evaluationFinalizedWithAcwDate)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EVALUATIONSTARTED("EvaluationStarted"),
        EVALUATIONINPROGRESS("EvaluationInProgress"),
        EVALUATIONFINALIZED("EvaluationFinalized"),
        EVALUATIONFINALIZEDWITHACW("EvaluationFinalizedWithAcw");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VOICE("Voice"),
        MESSAGE("Message"),
        EMAIL("Email");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("Inbound"),
        OUTBOUND("Outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

