/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.connector.okhttp;

import com.mypurecloud.sdk.v2.connector.ApiClientConnectorResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpResponse
implements ApiClientConnectorResponse {
    private final Response response;
    private String responseBody;
    private boolean hasReadBody = false;

    public OkHttpResponse(Response response) {
        this.response = response;
    }

    @Override
    public int getStatusCode() {
        return this.response.code();
    }

    @Override
    public String getStatusReasonPhrase() {
        return this.response.message();
    }

    @Override
    public Map<String, String> getHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        Headers headers = this.response.headers();
        if (headers != null) {
            for (String name : headers.names()) {
                map.put(name, headers.get(name));
            }
        }
        return map;
    }

    @Override
    public boolean hasBody() {
        try {
            String bodyString = this.readBody();
            return bodyString != null && !bodyString.isEmpty();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public String readBody() throws IOException {
        if (this.hasReadBody) {
            return this.responseBody;
        }
        this.hasReadBody = true;
        ResponseBody body = this.response.body();
        this.responseBody = body != null ? body.string() : null;
        return this.responseBody;
    }

    @Override
    public InputStream getBody() throws IOException {
        ResponseBody body = this.response.body();
        return body != null ? body.byteStream() : null;
    }

    @Override
    public void close() throws Exception {
        if (this.response != null && this.response.body() != null) {
            this.response.close();
        }
    }
}

