/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.AgentGreeting;
import java.util.HashMap;
import java.util.Map;

public class PutTelephonyAgentGreetingsRequest {
    private String agentId;
    private AgentGreeting body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public PutTelephonyAgentGreetingsRequest withAgentId(String agentId) {
        this.setAgentId(agentId);
        return this;
    }

    public AgentGreeting getBody() {
        return this.body;
    }

    public void setBody(AgentGreeting body) {
        this.body = body;
    }

    public PutTelephonyAgentGreetingsRequest withBody(AgentGreeting body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutTelephonyAgentGreetingsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<AgentGreeting> withHttpInfo() {
        if (this.agentId == null) {
            throw new IllegalStateException("Missing the required parameter 'agentId' when building request for PutTelephonyAgentGreetingsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutTelephonyAgentGreetingsRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/telephony/agents/{agentId}/greetings").withPathParameter("agentId", this.agentId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String agentId, AgentGreeting body) {
        return new Builder().withRequiredParams(agentId, body);
    }

    public static class Builder {
        private final PutTelephonyAgentGreetingsRequest request = new PutTelephonyAgentGreetingsRequest();

        private Builder() {
        }

        public Builder withAgentId(String agentId) {
            this.request.setAgentId(agentId);
            return this;
        }

        public Builder withBody(AgentGreeting body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String agentId, AgentGreeting body) {
            this.request.setAgentId(agentId);
            this.request.setBody(body);
            return this;
        }

        public PutTelephonyAgentGreetingsRequest build() {
            if (this.request.agentId == null) {
                throw new IllegalStateException("Missing the required parameter 'agentId' when building request for PutTelephonyAgentGreetingsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutTelephonyAgentGreetingsRequest.");
            }
            return this.request;
        }
    }
}

