/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.TransferToAddressRequest;
import java.util.HashMap;
import java.util.Map;

public class PostConversationParticipantTransferRequest {
    private String conversationId;
    private String participantId;
    private TransferToAddressRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PostConversationParticipantTransferRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public PostConversationParticipantTransferRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public TransferToAddressRequest getBody() {
        return this.body;
    }

    public void setBody(TransferToAddressRequest body) {
        this.body = body;
    }

    public PostConversationParticipantTransferRequest withBody(TransferToAddressRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationParticipantTransferRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<TransferToAddressRequest> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationParticipantTransferRequest.");
        }
        if (this.participantId == null) {
            throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PostConversationParticipantTransferRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationParticipantTransferRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/{conversationId}/participants/{participantId}/transfer").withPathParameter("conversationId", this.conversationId).withPathParameter("participantId", this.participantId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String participantId, TransferToAddressRequest body) {
        return new Builder().withRequiredParams(conversationId, participantId, body);
    }

    public static class Builder {
        private final PostConversationParticipantTransferRequest request = new PostConversationParticipantTransferRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withBody(TransferToAddressRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String participantId, TransferToAddressRequest body) {
            this.request.setConversationId(conversationId);
            this.request.setParticipantId(participantId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationParticipantTransferRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationParticipantTransferRequest.");
            }
            if (this.request.participantId == null) {
                throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PostConversationParticipantTransferRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationParticipantTransferRequest.");
            }
            return this.request;
        }
    }
}

