/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.UsersRulesUpdateRuleRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchUsersRuleRequest {
    private String ruleId;
    private UsersRulesUpdateRuleRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public PatchUsersRuleRequest withRuleId(String ruleId) {
        this.setRuleId(ruleId);
        return this;
    }

    public UsersRulesUpdateRuleRequest getBody() {
        return this.body;
    }

    public void setBody(UsersRulesUpdateRuleRequest body) {
        this.body = body;
    }

    public PatchUsersRuleRequest withBody(UsersRulesUpdateRuleRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchUsersRuleRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<UsersRulesUpdateRuleRequest> withHttpInfo() {
        if (this.ruleId == null) {
            throw new IllegalStateException("Missing the required parameter 'ruleId' when building request for PatchUsersRuleRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchUsersRuleRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/users/rules/{ruleId}").withPathParameter("ruleId", this.ruleId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String ruleId, UsersRulesUpdateRuleRequest body) {
        return new Builder().withRequiredParams(ruleId, body);
    }

    public static class Builder {
        private final PatchUsersRuleRequest request = new PatchUsersRuleRequest();

        private Builder() {
        }

        public Builder withRuleId(String ruleId) {
            this.request.setRuleId(ruleId);
            return this;
        }

        public Builder withBody(UsersRulesUpdateRuleRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String ruleId, UsersRulesUpdateRuleRequest body) {
            this.request.setRuleId(ruleId);
            this.request.setBody(body);
            return this;
        }

        public PatchUsersRuleRequest build() {
            if (this.request.ruleId == null) {
                throw new IllegalStateException("Missing the required parameter 'ruleId' when building request for PatchUsersRuleRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchUsersRuleRequest.");
            }
            return this.request;
        }
    }
}

