/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class GetGamificationInsightsMembersRequest {
    private String filterType;
    private String filterId;
    private String granularity;
    private LocalDate startWorkday;
    private String reportsTo;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getFilterType() {
        return this.filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public GetGamificationInsightsMembersRequest withFilterType(String filterType) {
        this.setFilterType(filterType);
        return this;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public void setFilterId(String filterId) {
        this.filterId = filterId;
    }

    public GetGamificationInsightsMembersRequest withFilterId(String filterId) {
        this.setFilterId(filterId);
        return this;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public GetGamificationInsightsMembersRequest withGranularity(String granularity) {
        this.setGranularity(granularity);
        return this;
    }

    public LocalDate getStartWorkday() {
        return this.startWorkday;
    }

    public void setStartWorkday(LocalDate startWorkday) {
        this.startWorkday = startWorkday;
    }

    public GetGamificationInsightsMembersRequest withStartWorkday(LocalDate startWorkday) {
        this.setStartWorkday(startWorkday);
        return this;
    }

    public String getReportsTo() {
        return this.reportsTo;
    }

    public void setReportsTo(String reportsTo) {
        this.reportsTo = reportsTo;
    }

    public GetGamificationInsightsMembersRequest withReportsTo(String reportsTo) {
        this.setReportsTo(reportsTo);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetGamificationInsightsMembersRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.filterType == null) {
            throw new IllegalStateException("Missing the required parameter 'filterType' when building request for GetGamificationInsightsMembersRequest.");
        }
        if (this.filterId == null) {
            throw new IllegalStateException("Missing the required parameter 'filterId' when building request for GetGamificationInsightsMembersRequest.");
        }
        if (this.granularity == null) {
            throw new IllegalStateException("Missing the required parameter 'granularity' when building request for GetGamificationInsightsMembersRequest.");
        }
        if (this.startWorkday == null) {
            throw new IllegalStateException("Missing the required parameter 'startWorkday' when building request for GetGamificationInsightsMembersRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/gamification/insights/members").withQueryParameters("filterType", "", this.filterType).withQueryParameters("filterId", "", this.filterId).withQueryParameters("granularity", "", this.granularity).withQueryParameters("startWorkday", "", this.startWorkday).withQueryParameters("reportsTo", "", this.reportsTo).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String filterType, String filterId, String granularity, LocalDate startWorkday) {
        return new Builder().withRequiredParams(filterType, filterId, granularity, startWorkday);
    }

    public static class Builder {
        private final GetGamificationInsightsMembersRequest request = new GetGamificationInsightsMembersRequest();

        private Builder() {
        }

        public Builder withFilterType(String filterType) {
            this.request.setFilterType(filterType);
            return this;
        }

        public Builder withFilterType(filterTypeValues filterType) {
            this.request.setFilterType(filterType.toString());
            return this;
        }

        public Builder withFilterId(String filterId) {
            this.request.setFilterId(filterId);
            return this;
        }

        public Builder withGranularity(String granularity) {
            this.request.setGranularity(granularity);
            return this;
        }

        public Builder withGranularity(granularityValues granularity) {
            this.request.setGranularity(granularity.toString());
            return this;
        }

        public Builder withStartWorkday(LocalDate startWorkday) {
            this.request.setStartWorkday(startWorkday);
            return this;
        }

        public Builder withReportsTo(String reportsTo) {
            this.request.setReportsTo(reportsTo);
            return this;
        }

        public Builder withRequiredParams(String filterType, String filterId, String granularity, LocalDate startWorkday) {
            this.request.setFilterType(filterType);
            this.request.setFilterId(filterId);
            this.request.setGranularity(granularity);
            this.request.setStartWorkday(startWorkday);
            return this;
        }

        public GetGamificationInsightsMembersRequest build() {
            if (this.request.filterType == null) {
                throw new IllegalStateException("Missing the required parameter 'filterType' when building request for GetGamificationInsightsMembersRequest.");
            }
            if (this.request.filterId == null) {
                throw new IllegalStateException("Missing the required parameter 'filterId' when building request for GetGamificationInsightsMembersRequest.");
            }
            if (this.request.granularity == null) {
                throw new IllegalStateException("Missing the required parameter 'granularity' when building request for GetGamificationInsightsMembersRequest.");
            }
            if (this.request.startWorkday == null) {
                throw new IllegalStateException("Missing the required parameter 'startWorkday' when building request for GetGamificationInsightsMembersRequest.");
            }
            return this.request;
        }
    }

    public static enum granularityValues {
        WEEKLY("Weekly"),
        MONTHLY("Monthly");

        private String value;

        private granularityValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static granularityValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (granularityValues value : granularityValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return granularityValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum filterTypeValues {
        PERFORMANCEPROFILE("PerformanceProfile"),
        DIVISION("Division");

        private String value;

        private filterTypeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static filterTypeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (filterTypeValues value : filterTypeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return filterTypeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

