/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetAssistantQueueUsersJobRequest {
    private String assistantId;
    private String queueId;
    private String jobId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAssistantId() {
        return this.assistantId;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public GetAssistantQueueUsersJobRequest withAssistantId(String assistantId) {
        this.setAssistantId(assistantId);
        return this;
    }

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public GetAssistantQueueUsersJobRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public GetAssistantQueueUsersJobRequest withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetAssistantQueueUsersJobRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.assistantId == null) {
            throw new IllegalStateException("Missing the required parameter 'assistantId' when building request for GetAssistantQueueUsersJobRequest.");
        }
        if (this.queueId == null) {
            throw new IllegalStateException("Missing the required parameter 'queueId' when building request for GetAssistantQueueUsersJobRequest.");
        }
        if (this.jobId == null) {
            throw new IllegalStateException("Missing the required parameter 'jobId' when building request for GetAssistantQueueUsersJobRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/assistants/{assistantId}/queues/{queueId}/users/jobs/{jobId}").withPathParameter("assistantId", this.assistantId).withPathParameter("queueId", this.queueId).withPathParameter("jobId", this.jobId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String assistantId, String queueId, String jobId) {
        return new Builder().withRequiredParams(assistantId, queueId, jobId);
    }

    public static class Builder {
        private final GetAssistantQueueUsersJobRequest request = new GetAssistantQueueUsersJobRequest();

        private Builder() {
        }

        public Builder withAssistantId(String assistantId) {
            this.request.setAssistantId(assistantId);
            return this;
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withJobId(String jobId) {
            this.request.setJobId(jobId);
            return this;
        }

        public Builder withRequiredParams(String assistantId, String queueId, String jobId) {
            this.request.setAssistantId(assistantId);
            this.request.setQueueId(queueId);
            this.request.setJobId(jobId);
            return this;
        }

        public GetAssistantQueueUsersJobRequest build() {
            if (this.request.assistantId == null) {
                throw new IllegalStateException("Missing the required parameter 'assistantId' when building request for GetAssistantQueueUsersJobRequest.");
            }
            if (this.request.queueId == null) {
                throw new IllegalStateException("Missing the required parameter 'queueId' when building request for GetAssistantQueueUsersJobRequest.");
            }
            if (this.request.jobId == null) {
                throw new IllegalStateException("Missing the required parameter 'jobId' when building request for GetAssistantQueueUsersJobRequest.");
            }
            return this.request;
        }
    }
}

