/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteUsersRuleRequest;
import com.mypurecloud.sdk.v2.api.request.GetUsersRuleDependentTypeIdRequest;
import com.mypurecloud.sdk.v2.api.request.GetUsersRuleDependentsRequest;
import com.mypurecloud.sdk.v2.api.request.GetUsersRuleRequest;
import com.mypurecloud.sdk.v2.api.request.GetUsersRulesRequest;
import com.mypurecloud.sdk.v2.api.request.GetUsersRulesSettingRequest;
import com.mypurecloud.sdk.v2.api.request.PatchUsersRuleRequest;
import com.mypurecloud.sdk.v2.api.request.PostUsersRulesQueryRequest;
import com.mypurecloud.sdk.v2.api.request.PostUsersRulesRequest;
import com.mypurecloud.sdk.v2.model.UsersRulesCreateRuleRequest;
import com.mypurecloud.sdk.v2.model.UsersRulesDependent;
import com.mypurecloud.sdk.v2.model.UsersRulesDependentList;
import com.mypurecloud.sdk.v2.model.UsersRulesQueryResponse;
import com.mypurecloud.sdk.v2.model.UsersRulesQueryRuleRequest;
import com.mypurecloud.sdk.v2.model.UsersRulesRule;
import com.mypurecloud.sdk.v2.model.UsersRulesRuleList;
import com.mypurecloud.sdk.v2.model.UsersRulesRuleSettings;
import com.mypurecloud.sdk.v2.model.UsersRulesUpdateRuleRequest;
import java.io.IOException;
import java.util.List;

public class UsersRulesApi {
    private final ApiClient pcapiClient;

    public UsersRulesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsersRulesApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteUsersRule(String ruleId) throws IOException, ApiException {
        this.deleteUsersRule(this.createDeleteUsersRuleRequest(ruleId));
    }

    public ApiResponse<Void> deleteUsersRuleWithHttpInfo(String ruleId) throws IOException {
        return this.deleteUsersRule(this.createDeleteUsersRuleRequest(ruleId).withHttpInfo());
    }

    private DeleteUsersRuleRequest createDeleteUsersRuleRequest(String ruleId) {
        return DeleteUsersRuleRequest.builder().withRuleId(ruleId).build();
    }

    public void deleteUsersRule(DeleteUsersRuleRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteUsersRule(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsersRulesRule getUsersRule(String ruleId) throws IOException, ApiException {
        return this.getUsersRule(this.createGetUsersRuleRequest(ruleId));
    }

    public ApiResponse<UsersRulesRule> getUsersRuleWithHttpInfo(String ruleId) throws IOException {
        return this.getUsersRule(this.createGetUsersRuleRequest(ruleId).withHttpInfo());
    }

    private GetUsersRuleRequest createGetUsersRuleRequest(String ruleId) {
        return GetUsersRuleRequest.builder().withRuleId(ruleId).build();
    }

    public UsersRulesRule getUsersRule(GetUsersRuleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsersRulesRule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsersRulesRule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsersRulesRule> getUsersRule(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsersRulesRule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsersRulesDependent getUsersRuleDependentTypeId(String ruleId, String ruleType, String typeId) throws IOException, ApiException {
        return this.getUsersRuleDependentTypeId(this.createGetUsersRuleDependentTypeIdRequest(ruleId, ruleType, typeId));
    }

    public ApiResponse<UsersRulesDependent> getUsersRuleDependentTypeIdWithHttpInfo(String ruleId, String ruleType, String typeId) throws IOException {
        return this.getUsersRuleDependentTypeId(this.createGetUsersRuleDependentTypeIdRequest(ruleId, ruleType, typeId).withHttpInfo());
    }

    private GetUsersRuleDependentTypeIdRequest createGetUsersRuleDependentTypeIdRequest(String ruleId, String ruleType, String typeId) {
        return GetUsersRuleDependentTypeIdRequest.builder().withRuleId(ruleId).withRuleType(ruleType).withTypeId(typeId).build();
    }

    public UsersRulesDependent getUsersRuleDependentTypeId(GetUsersRuleDependentTypeIdRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsersRulesDependent> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsersRulesDependent>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsersRulesDependent> getUsersRuleDependentTypeId(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsersRulesDependent>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsersRulesDependentList getUsersRuleDependents(String ruleId, Integer pageSize, Integer pageNumber, String sortOrder) throws IOException, ApiException {
        return this.getUsersRuleDependents(this.createGetUsersRuleDependentsRequest(ruleId, pageSize, pageNumber, sortOrder));
    }

    public ApiResponse<UsersRulesDependentList> getUsersRuleDependentsWithHttpInfo(String ruleId, Integer pageSize, Integer pageNumber, String sortOrder) throws IOException {
        return this.getUsersRuleDependents(this.createGetUsersRuleDependentsRequest(ruleId, pageSize, pageNumber, sortOrder).withHttpInfo());
    }

    private GetUsersRuleDependentsRequest createGetUsersRuleDependentsRequest(String ruleId, Integer pageSize, Integer pageNumber, String sortOrder) {
        return GetUsersRuleDependentsRequest.builder().withRuleId(ruleId).withPageSize(pageSize).withPageNumber(pageNumber).withSortOrder(sortOrder).build();
    }

    public UsersRulesDependentList getUsersRuleDependents(GetUsersRuleDependentsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsersRulesDependentList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsersRulesDependentList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsersRulesDependentList> getUsersRuleDependents(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsersRulesDependentList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsersRulesRuleList getUsersRules(List<String> types, Integer pageNumber, Integer pageSize, List<String> expand, String searchTerm, String sortOrder) throws IOException, ApiException {
        return this.getUsersRules(this.createGetUsersRulesRequest(types, pageNumber, pageSize, expand, searchTerm, sortOrder));
    }

    public ApiResponse<UsersRulesRuleList> getUsersRulesWithHttpInfo(List<String> types, Integer pageNumber, Integer pageSize, List<String> expand, String searchTerm, String sortOrder) throws IOException {
        return this.getUsersRules(this.createGetUsersRulesRequest(types, pageNumber, pageSize, expand, searchTerm, sortOrder).withHttpInfo());
    }

    private GetUsersRulesRequest createGetUsersRulesRequest(List<String> types, Integer pageNumber, Integer pageSize, List<String> expand, String searchTerm, String sortOrder) {
        return GetUsersRulesRequest.builder().withTypes(types).withPageNumber(pageNumber).withPageSize(pageSize).withExpand(expand).withSearchTerm(searchTerm).withSortOrder(sortOrder).build();
    }

    public UsersRulesRuleList getUsersRules(GetUsersRulesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsersRulesRuleList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsersRulesRuleList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsersRulesRuleList> getUsersRules(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsersRulesRuleList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsersRulesRuleSettings getUsersRulesSetting(String ruleType) throws IOException, ApiException {
        return this.getUsersRulesSetting(this.createGetUsersRulesSettingRequest(ruleType));
    }

    public ApiResponse<UsersRulesRuleSettings> getUsersRulesSettingWithHttpInfo(String ruleType) throws IOException {
        return this.getUsersRulesSetting(this.createGetUsersRulesSettingRequest(ruleType).withHttpInfo());
    }

    private GetUsersRulesSettingRequest createGetUsersRulesSettingRequest(String ruleType) {
        return GetUsersRulesSettingRequest.builder().withRuleType(ruleType).build();
    }

    public UsersRulesRuleSettings getUsersRulesSetting(GetUsersRulesSettingRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsersRulesRuleSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsersRulesRuleSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsersRulesRuleSettings> getUsersRulesSetting(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsersRulesRuleSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsersRulesRule patchUsersRule(String ruleId, UsersRulesUpdateRuleRequest body) throws IOException, ApiException {
        return this.patchUsersRule(this.createPatchUsersRuleRequest(ruleId, body));
    }

    public ApiResponse<UsersRulesRule> patchUsersRuleWithHttpInfo(String ruleId, UsersRulesUpdateRuleRequest body) throws IOException {
        return this.patchUsersRule(this.createPatchUsersRuleRequest(ruleId, body).withHttpInfo());
    }

    private PatchUsersRuleRequest createPatchUsersRuleRequest(String ruleId, UsersRulesUpdateRuleRequest body) {
        return PatchUsersRuleRequest.builder().withRuleId(ruleId).withBody(body).build();
    }

    public UsersRulesRule patchUsersRule(PatchUsersRuleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsersRulesRule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsersRulesRule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsersRulesRule> patchUsersRule(ApiRequest<UsersRulesUpdateRuleRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsersRulesRule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsersRulesRule postUsersRules(UsersRulesCreateRuleRequest body) throws IOException, ApiException {
        return this.postUsersRules(this.createPostUsersRulesRequest(body));
    }

    public ApiResponse<UsersRulesRule> postUsersRulesWithHttpInfo(UsersRulesCreateRuleRequest body) throws IOException {
        return this.postUsersRules(this.createPostUsersRulesRequest(body).withHttpInfo());
    }

    private PostUsersRulesRequest createPostUsersRulesRequest(UsersRulesCreateRuleRequest body) {
        return PostUsersRulesRequest.builder().withBody(body).build();
    }

    public UsersRulesRule postUsersRules(PostUsersRulesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsersRulesRule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsersRulesRule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsersRulesRule> postUsersRules(ApiRequest<UsersRulesCreateRuleRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsersRulesRule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsersRulesQueryResponse postUsersRulesQuery(UsersRulesQueryRuleRequest body, Integer pageNumber, Integer pageSize) throws IOException, ApiException {
        return this.postUsersRulesQuery(this.createPostUsersRulesQueryRequest(body, pageNumber, pageSize));
    }

    public ApiResponse<UsersRulesQueryResponse> postUsersRulesQueryWithHttpInfo(UsersRulesQueryRuleRequest body, Integer pageNumber, Integer pageSize) throws IOException {
        return this.postUsersRulesQuery(this.createPostUsersRulesQueryRequest(body, pageNumber, pageSize).withHttpInfo());
    }

    private PostUsersRulesQueryRequest createPostUsersRulesQueryRequest(UsersRulesQueryRuleRequest body, Integer pageNumber, Integer pageSize) {
        return PostUsersRulesQueryRequest.builder().withBody(body).withPageNumber(pageNumber).withPageSize(pageSize).build();
    }

    public UsersRulesQueryResponse postUsersRulesQuery(PostUsersRulesQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsersRulesQueryResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsersRulesQueryResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsersRulesQueryResponse> postUsersRulesQuery(ApiRequest<UsersRulesQueryRuleRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsersRulesQueryResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

