/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Represents an organization skill assigned to a user. When assigning to a user specify the organization skill id as the id.")
public class UserRoutingSkillPost
implements Serializable {
    private String id = null;
    private Double proficiency = null;
    private String skillUri = null;
    private String selfUri = null;

    public UserRoutingSkillPost() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public UserRoutingSkillPost id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the existing routing skill to add to the user")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UserRoutingSkillPost proficiency(Double proficiency) {
        this.proficiency = proficiency;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Proficiency is a rating from 0.0 to 5.0 on how competent an agent is for a particular skill. It is used when a queue is set to \"Best available skills\" mode to allow acd interactions to target agents with higher proficiency ratings.")
    @JsonProperty(value="proficiency")
    public Double getProficiency() {
        return this.proficiency;
    }

    public void setProficiency(Double proficiency) {
        this.proficiency = proficiency;
    }

    @ApiModelProperty(example="null", value="URI to the organization skill used by this user skill.")
    @JsonProperty(value="skillUri")
    public String getSkillUri() {
        return this.skillUri;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserRoutingSkillPost userRoutingSkillPost = (UserRoutingSkillPost)o;
        return Objects.equals(this.id, userRoutingSkillPost.id) && Objects.equals(this.proficiency, userRoutingSkillPost.proficiency) && Objects.equals(this.skillUri, userRoutingSkillPost.skillUri) && Objects.equals(this.selfUri, userRoutingSkillPost.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.proficiency, this.skillUri, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserRoutingSkillPost {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    proficiency: ").append(this.toIndentedString(this.proficiency)).append("\n");
        sb.append("    skillUri: ").append(this.toIndentedString(this.skillUri)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

