/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.TextBotDisconnectAction;
import com.mypurecloud.sdk.v2.model.TextBotExitAction;
import com.mypurecloud.sdk.v2.model.TextBotOutputPrompts;
import com.mypurecloud.sdk.v2.model.TextBotTurnReference;
import com.mypurecloud.sdk.v2.model.TextBotWaitForInputAction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Information related to a success bot flow turn request.")
public class TextBotFlowTurnResponse
implements Serializable {
    private String id = null;
    private TextBotTurnReference previousTurn = null;
    private TextBotOutputPrompts prompts = null;
    private NextActionTypeEnum nextActionType = null;
    private TextBotDisconnectAction nextActionDisconnect = null;
    private TextBotWaitForInputAction nextActionWaitForInput = null;
    private TextBotExitAction nextActionExit = null;

    public TextBotFlowTurnResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public TextBotFlowTurnResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the bot flow turn. If additional turns are needed, supply this ID as the previous turn in your next turn request.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TextBotFlowTurnResponse previousTurn(TextBotTurnReference previousTurn) {
        this.previousTurn = previousTurn;
        return this;
    }

    @ApiModelProperty(example="null", value="The reference to a previous turn, if applicable.")
    @JsonProperty(value="previousTurn")
    public TextBotTurnReference getPreviousTurn() {
        return this.previousTurn;
    }

    public void setPreviousTurn(TextBotTurnReference previousTurn) {
        this.previousTurn = previousTurn;
    }

    public TextBotFlowTurnResponse prompts(TextBotOutputPrompts prompts) {
        this.prompts = prompts;
        return this;
    }

    @ApiModelProperty(example="null", value="The output prompts for this turn.")
    @JsonProperty(value="prompts")
    public TextBotOutputPrompts getPrompts() {
        return this.prompts;
    }

    public void setPrompts(TextBotOutputPrompts prompts) {
        this.prompts = prompts;
    }

    public TextBotFlowTurnResponse nextActionType(NextActionTypeEnum nextActionType) {
        this.nextActionType = nextActionType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates the suggested next action. If appropriate, the matching output event object includes additional information.")
    @JsonProperty(value="nextActionType")
    public NextActionTypeEnum getNextActionType() {
        return this.nextActionType;
    }

    public void setNextActionType(NextActionTypeEnum nextActionType) {
        this.nextActionType = nextActionType;
    }

    public TextBotFlowTurnResponse nextActionDisconnect(TextBotDisconnectAction nextActionDisconnect) {
        this.nextActionDisconnect = nextActionDisconnect;
        return this;
    }

    @ApiModelProperty(example="null", value="The next action directive for this turn if it is a Disconnect type.")
    @JsonProperty(value="nextActionDisconnect")
    public TextBotDisconnectAction getNextActionDisconnect() {
        return this.nextActionDisconnect;
    }

    public void setNextActionDisconnect(TextBotDisconnectAction nextActionDisconnect) {
        this.nextActionDisconnect = nextActionDisconnect;
    }

    public TextBotFlowTurnResponse nextActionWaitForInput(TextBotWaitForInputAction nextActionWaitForInput) {
        this.nextActionWaitForInput = nextActionWaitForInput;
        return this;
    }

    @ApiModelProperty(example="null", value="The next action directive for this turn if it is a WaitForInput type.")
    @JsonProperty(value="nextActionWaitForInput")
    public TextBotWaitForInputAction getNextActionWaitForInput() {
        return this.nextActionWaitForInput;
    }

    public void setNextActionWaitForInput(TextBotWaitForInputAction nextActionWaitForInput) {
        this.nextActionWaitForInput = nextActionWaitForInput;
    }

    public TextBotFlowTurnResponse nextActionExit(TextBotExitAction nextActionExit) {
        this.nextActionExit = nextActionExit;
        return this;
    }

    @ApiModelProperty(example="null", value="The next action directive for this turn if it is an Exit type.")
    @JsonProperty(value="nextActionExit")
    public TextBotExitAction getNextActionExit() {
        return this.nextActionExit;
    }

    public void setNextActionExit(TextBotExitAction nextActionExit) {
        this.nextActionExit = nextActionExit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextBotFlowTurnResponse textBotFlowTurnResponse = (TextBotFlowTurnResponse)o;
        return Objects.equals(this.id, textBotFlowTurnResponse.id) && Objects.equals(this.previousTurn, textBotFlowTurnResponse.previousTurn) && Objects.equals(this.prompts, textBotFlowTurnResponse.prompts) && Objects.equals((Object)this.nextActionType, (Object)textBotFlowTurnResponse.nextActionType) && Objects.equals(this.nextActionDisconnect, textBotFlowTurnResponse.nextActionDisconnect) && Objects.equals(this.nextActionWaitForInput, textBotFlowTurnResponse.nextActionWaitForInput) && Objects.equals(this.nextActionExit, textBotFlowTurnResponse.nextActionExit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.previousTurn, this.prompts, this.nextActionType, this.nextActionDisconnect, this.nextActionWaitForInput, this.nextActionExit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextBotFlowTurnResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    previousTurn: ").append(this.toIndentedString(this.previousTurn)).append("\n");
        sb.append("    prompts: ").append(this.toIndentedString(this.prompts)).append("\n");
        sb.append("    nextActionType: ").append(this.toIndentedString((Object)this.nextActionType)).append("\n");
        sb.append("    nextActionDisconnect: ").append(this.toIndentedString(this.nextActionDisconnect)).append("\n");
        sb.append("    nextActionWaitForInput: ").append(this.toIndentedString(this.nextActionWaitForInput)).append("\n");
        sb.append("    nextActionExit: ").append(this.toIndentedString(this.nextActionExit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=NextActionTypeEnumDeserializer.class)
    public static enum NextActionTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NOOP("NoOp"),
        DISCONNECT("Disconnect"),
        WAITFORINPUT("WaitForInput"),
        EXIT("Exit");

        private String value;

        private NextActionTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static NextActionTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (NextActionTypeEnum value : NextActionTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return NextActionTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class NextActionTypeEnumDeserializer
    extends StdDeserializer<NextActionTypeEnum> {
        public NextActionTypeEnumDeserializer() {
            super(NextActionTypeEnumDeserializer.class);
        }

        public NextActionTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return NextActionTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

