/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.MediaTypes;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Supported content profile for inbound and outbound messages")
public class SupportedContent
implements Serializable {
    private String id = null;
    private String name = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private DomainEntityRef createdBy = null;
    private DomainEntityRef modifiedBy = null;
    private Integer version = null;
    private MediaTypes mediaTypes = null;
    private String selfUri = null;

    public SupportedContent() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", required=true, value="A unique supported content Id.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public SupportedContent name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the supported content profile")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Date this supported content profile was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Date this supported content profile was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="User reference that created this supported content profile")
    @JsonProperty(value="createdBy")
    public DomainEntityRef getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(example="null", value="User reference that modified this supported content profile")
    @JsonProperty(value="modifiedBy")
    public DomainEntityRef getModifiedBy() {
        return this.modifiedBy;
    }

    @ApiModelProperty(example="null", value="Version number")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public SupportedContent mediaTypes(MediaTypes mediaTypes) {
        this.mediaTypes = mediaTypes;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines the allowable media that may be accepted for an inbound message or to be sent in an outbound message. The following is an example of allowing all inbound media, and for outbound all images and only mpeg video: {   \"mediaTypes\": {     \"allow\": {       \"inbound\": [{\"type\": \"*\\/\\*\"}],       \"outbound\": [{\"type\": \"image/*\"}, {\"type\": \"video/mpeg\"}]     }   } }")
    @JsonProperty(value="mediaTypes")
    public MediaTypes getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(MediaTypes mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportedContent supportedContent = (SupportedContent)o;
        return Objects.equals(this.id, supportedContent.id) && Objects.equals(this.name, supportedContent.name) && Objects.equals(this.dateCreated, supportedContent.dateCreated) && Objects.equals(this.dateModified, supportedContent.dateModified) && Objects.equals(this.createdBy, supportedContent.createdBy) && Objects.equals(this.modifiedBy, supportedContent.modifiedBy) && Objects.equals(this.version, supportedContent.version) && Objects.equals(this.mediaTypes, supportedContent.mediaTypes) && Objects.equals(this.selfUri, supportedContent.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.dateCreated, this.dateModified, this.createdBy, this.modifiedBy, this.version, this.mediaTypes, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SupportedContent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    mediaTypes: ").append(this.toIndentedString(this.mediaTypes)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

