/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.SummarySettingCustomEntity;
import com.mypurecloud.sdk.v2.model.SummarySettingPII;
import com.mypurecloud.sdk.v2.model.SummarySettingParticipantLabels;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class SummarySetting
implements Serializable {
    private String id = null;
    private String name = null;
    private String language = null;
    private SummaryTypeEnum summaryType = null;
    private FormatEnum format = null;
    private SummarySettingPII maskPII = null;
    private SummarySettingParticipantLabels participantLabels = null;
    private List<PredefinedInsightsEnum> predefinedInsights = null;
    private List<SummarySettingCustomEntity> customEntities = null;
    private SettingTypeEnum settingType = null;
    private String prompt = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String selfUri = null;

    public SummarySetting() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.predefinedInsights = new ArrayList<PredefinedInsightsEnum>();
            this.customEntities = new ArrayList<SummarySettingCustomEntity>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public SummarySetting name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the summary setting.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SummarySetting language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Language of the generated summary, e.g. en-US, it-IT.")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public SummarySetting summaryType(SummaryTypeEnum summaryType) {
        this.summaryType = summaryType;
        return this;
    }

    @ApiModelProperty(example="null", value="Level of detail of the generated summary.")
    @JsonProperty(value="summaryType")
    public SummaryTypeEnum getSummaryType() {
        return this.summaryType;
    }

    public void setSummaryType(SummaryTypeEnum summaryType) {
        this.summaryType = summaryType;
    }

    public SummarySetting format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(example="null", value="Format of the generated summary.")
    @JsonProperty(value="format")
    public FormatEnum getFormat() {
        return this.format;
    }

    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public SummarySetting maskPII(SummarySettingPII maskPII) {
        this.maskPII = maskPII;
        return this;
    }

    @ApiModelProperty(example="null", value="Displaying PII in the generated summary.")
    @JsonProperty(value="maskPII")
    public SummarySettingPII getMaskPII() {
        return this.maskPII;
    }

    public void setMaskPII(SummarySettingPII maskPII) {
        this.maskPII = maskPII;
    }

    public SummarySetting participantLabels(SummarySettingParticipantLabels participantLabels) {
        this.participantLabels = participantLabels;
        return this;
    }

    @ApiModelProperty(example="null", value="How to refer to interaction participants in the generated summary.")
    @JsonProperty(value="participantLabels")
    public SummarySettingParticipantLabels getParticipantLabels() {
        return this.participantLabels;
    }

    public void setParticipantLabels(SummarySettingParticipantLabels participantLabels) {
        this.participantLabels = participantLabels;
    }

    public SummarySetting predefinedInsights(List<PredefinedInsightsEnum> predefinedInsights) {
        this.predefinedInsights = predefinedInsights;
        return this;
    }

    @ApiModelProperty(example="null", value="Set which insights to include in the generated summary by default.")
    @JsonProperty(value="predefinedInsights")
    public List<PredefinedInsightsEnum> getPredefinedInsights() {
        return this.predefinedInsights;
    }

    public void setPredefinedInsights(List<PredefinedInsightsEnum> predefinedInsights) {
        this.predefinedInsights = predefinedInsights;
    }

    public SummarySetting customEntities(List<SummarySettingCustomEntity> customEntities) {
        this.customEntities = customEntities;
        return this;
    }

    @ApiModelProperty(example="null", value="Custom entity definition.")
    @JsonProperty(value="customEntities")
    public List<SummarySettingCustomEntity> getCustomEntities() {
        return this.customEntities;
    }

    public void setCustomEntities(List<SummarySettingCustomEntity> customEntities) {
        this.customEntities = customEntities;
    }

    public SummarySetting settingType(SettingTypeEnum settingType) {
        this.settingType = settingType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the summary setting.")
    @JsonProperty(value="settingType")
    public SettingTypeEnum getSettingType() {
        return this.settingType;
    }

    public void setSettingType(SettingTypeEnum settingType) {
        this.settingType = settingType;
    }

    public SummarySetting prompt(String prompt) {
        this.prompt = prompt;
        return this;
    }

    @ApiModelProperty(example="null", value="Custom prompt of summary setting.")
    @JsonProperty(value="prompt")
    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    @ApiModelProperty(example="null", value="The date and time the setting was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The date and time the setting was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SummarySetting summarySetting = (SummarySetting)o;
        return Objects.equals(this.id, summarySetting.id) && Objects.equals(this.name, summarySetting.name) && Objects.equals(this.language, summarySetting.language) && Objects.equals((Object)this.summaryType, (Object)summarySetting.summaryType) && Objects.equals((Object)this.format, (Object)summarySetting.format) && Objects.equals(this.maskPII, summarySetting.maskPII) && Objects.equals(this.participantLabels, summarySetting.participantLabels) && Objects.equals(this.predefinedInsights, summarySetting.predefinedInsights) && Objects.equals(this.customEntities, summarySetting.customEntities) && Objects.equals((Object)this.settingType, (Object)summarySetting.settingType) && Objects.equals(this.prompt, summarySetting.prompt) && Objects.equals(this.dateCreated, summarySetting.dateCreated) && Objects.equals(this.dateModified, summarySetting.dateModified) && Objects.equals(this.selfUri, summarySetting.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.language, this.summaryType, this.format, this.maskPII, this.participantLabels, this.predefinedInsights, this.customEntities, this.settingType, this.prompt, this.dateCreated, this.dateModified, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SummarySetting {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    summaryType: ").append(this.toIndentedString((Object)this.summaryType)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    maskPII: ").append(this.toIndentedString(this.maskPII)).append("\n");
        sb.append("    participantLabels: ").append(this.toIndentedString(this.participantLabels)).append("\n");
        sb.append("    predefinedInsights: ").append(this.toIndentedString(this.predefinedInsights)).append("\n");
        sb.append("    customEntities: ").append(this.toIndentedString(this.customEntities)).append("\n");
        sb.append("    settingType: ").append(this.toIndentedString((Object)this.settingType)).append("\n");
        sb.append("    prompt: ").append(this.toIndentedString(this.prompt)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SummaryTypeEnumDeserializer.class)
    public static enum SummaryTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CONCISE("Concise"),
        DETAILED("Detailed");

        private String value;

        private SummaryTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SummaryTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SummaryTypeEnum value : SummaryTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SummaryTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=FormatEnumDeserializer.class)
    public static enum FormatEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TEXTBLOCK("TextBlock"),
        BULLETPOINTS("BulletPoints"),
        GROUPEDTEXTBLOCKS("GroupedTextBlocks"),
        GROUPEDBULLETPOINTS("GroupedBulletPoints");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FormatEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FormatEnum value : FormatEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FormatEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SettingTypeEnumDeserializer.class)
    public static enum SettingTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BASIC("Basic"),
        PROMPT("Prompt");

        private String value;

        private SettingTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SettingTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SettingTypeEnum value : SettingTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SettingTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SettingTypeEnumDeserializer
    extends StdDeserializer<SettingTypeEnum> {
        public SettingTypeEnumDeserializer() {
            super(SettingTypeEnumDeserializer.class);
        }

        public SettingTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SettingTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=PredefinedInsightsEnumDeserializer.class)
    public static enum PredefinedInsightsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        REASONFORCALL("ReasonForCall"),
        RESOLUTION("Resolution"),
        ACTIONITEMS("ActionItems");

        private String value;

        private PredefinedInsightsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PredefinedInsightsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PredefinedInsightsEnum value : PredefinedInsightsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PredefinedInsightsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PredefinedInsightsEnumDeserializer
    extends StdDeserializer<PredefinedInsightsEnum> {
        public PredefinedInsightsEnumDeserializer() {
            super(PredefinedInsightsEnumDeserializer.class);
        }

        public PredefinedInsightsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PredefinedInsightsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class FormatEnumDeserializer
    extends StdDeserializer<FormatEnum> {
        public FormatEnumDeserializer() {
            super(FormatEnumDeserializer.class);
        }

        public FormatEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FormatEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SummaryTypeEnumDeserializer
    extends StdDeserializer<SummaryTypeEnum> {
        public SummaryTypeEnumDeserializer() {
            super(SummaryTypeEnumDeserializer.class);
        }

        public SummaryTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SummaryTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

