/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class SessionInfo
implements Serializable {
    private Integer version = null;
    private String sessionId = null;
    private String businessUnitId = null;
    private Integer planningGroupsVersion = null;
    private Date dateOfSession = null;

    public SessionInfo() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public SessionInfo version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Version of the continuous forecast session")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public SessionInfo sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="Session ID of the continuous forecast session")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public SessionInfo businessUnitId(String businessUnitId) {
        this.businessUnitId = businessUnitId;
        return this;
    }

    @ApiModelProperty(example="null", value="Business unit ID of the continuous forecast session")
    @JsonProperty(value="businessUnitId")
    public String getBusinessUnitId() {
        return this.businessUnitId;
    }

    public void setBusinessUnitId(String businessUnitId) {
        this.businessUnitId = businessUnitId;
    }

    public SessionInfo planningGroupsVersion(Integer planningGroupsVersion) {
        this.planningGroupsVersion = planningGroupsVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="Version of the planning groups")
    @JsonProperty(value="planningGroupsVersion")
    public Integer getPlanningGroupsVersion() {
        return this.planningGroupsVersion;
    }

    public void setPlanningGroupsVersion(Integer planningGroupsVersion) {
        this.planningGroupsVersion = planningGroupsVersion;
    }

    public SessionInfo dateOfSession(Date dateOfSession) {
        this.dateOfSession = dateOfSession;
        return this;
    }

    @ApiModelProperty(example="null", value="Date and Time of the Session. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateOfSession")
    public Date getDateOfSession() {
        return this.dateOfSession;
    }

    public void setDateOfSession(Date dateOfSession) {
        this.dateOfSession = dateOfSession;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionInfo sessionInfo = (SessionInfo)o;
        return Objects.equals(this.version, sessionInfo.version) && Objects.equals(this.sessionId, sessionInfo.sessionId) && Objects.equals(this.businessUnitId, sessionInfo.businessUnitId) && Objects.equals(this.planningGroupsVersion, sessionInfo.planningGroupsVersion) && Objects.equals(this.dateOfSession, sessionInfo.dateOfSession);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.sessionId, this.businessUnitId, this.planningGroupsVersion, this.dateOfSession);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SessionInfo {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    businessUnitId: ").append(this.toIndentedString(this.businessUnitId)).append("\n");
        sb.append("    planningGroupsVersion: ").append(this.toIndentedString(this.planningGroupsVersion)).append("\n");
        sb.append("    dateOfSession: ").append(this.toIndentedString(this.dateOfSession)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

