/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.PaymentLineItem;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PaymentRequest
implements Serializable {
    private PaymentPlatformEnum paymentPlatform = null;
    private String countryCode = null;
    private String currencyCode = null;
    private Double orderTotal = null;
    private List<PaymentLineItem> lineItems = null;
    private List<PaymentLineItem> shippingOptions = null;

    public PaymentRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.lineItems = new ArrayList<PaymentLineItem>();
            this.shippingOptions = new ArrayList<PaymentLineItem>();
        }
    }

    public PaymentRequest paymentPlatform(PaymentPlatformEnum paymentPlatform) {
        this.paymentPlatform = paymentPlatform;
        return this;
    }

    @ApiModelProperty(example="null", value="The payment platform being used (e.g. Apple Pay)")
    @JsonProperty(value="paymentPlatform")
    public PaymentPlatformEnum getPaymentPlatform() {
        return this.paymentPlatform;
    }

    public void setPaymentPlatform(PaymentPlatformEnum paymentPlatform) {
        this.paymentPlatform = paymentPlatform;
    }

    public PaymentRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The merchant's two-letter ISO 3166 country code.")
    @JsonProperty(value="countryCode")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public PaymentRequest currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The three-letter ISO 4217 currency code for the payment.")
    @JsonProperty(value="currencyCode")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public PaymentRequest orderTotal(Double orderTotal) {
        this.orderTotal = orderTotal;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The total price of the order.")
    @JsonProperty(value="orderTotal")
    public Double getOrderTotal() {
        return this.orderTotal;
    }

    public void setOrderTotal(Double orderTotal) {
        this.orderTotal = orderTotal;
    }

    public PaymentRequest lineItems(List<PaymentLineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    @ApiModelProperty(example="null", value="The items that make up the order.")
    @JsonProperty(value="lineItems")
    public List<PaymentLineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<PaymentLineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public PaymentRequest shippingOptions(List<PaymentLineItem> shippingOptions) {
        this.shippingOptions = shippingOptions;
        return this;
    }

    @ApiModelProperty(example="null", value="The available shipping options.")
    @JsonProperty(value="shippingOptions")
    public List<PaymentLineItem> getShippingOptions() {
        return this.shippingOptions;
    }

    public void setShippingOptions(List<PaymentLineItem> shippingOptions) {
        this.shippingOptions = shippingOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentRequest paymentRequest = (PaymentRequest)o;
        return Objects.equals((Object)this.paymentPlatform, (Object)paymentRequest.paymentPlatform) && Objects.equals(this.countryCode, paymentRequest.countryCode) && Objects.equals(this.currencyCode, paymentRequest.currencyCode) && Objects.equals(this.orderTotal, paymentRequest.orderTotal) && Objects.equals(this.lineItems, paymentRequest.lineItems) && Objects.equals(this.shippingOptions, paymentRequest.shippingOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentPlatform, this.countryCode, this.currencyCode, this.orderTotal, this.lineItems, this.shippingOptions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentRequest {\n");
        sb.append("    paymentPlatform: ").append(this.toIndentedString((Object)this.paymentPlatform)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    orderTotal: ").append(this.toIndentedString(this.orderTotal)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    shippingOptions: ").append(this.toIndentedString(this.shippingOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=PaymentPlatformEnumDeserializer.class)
    public static enum PaymentPlatformEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        APPLEPAY("ApplePay");

        private String value;

        private PaymentPlatformEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PaymentPlatformEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PaymentPlatformEnum value : PaymentPlatformEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PaymentPlatformEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PaymentPlatformEnumDeserializer
    extends StdDeserializer<PaymentPlatformEnum> {
        public PaymentPlatformEnumDeserializer() {
            super(PaymentPlatformEnumDeserializer.class);
        }

        public PaymentPlatformEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PaymentPlatformEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

