/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.EmailSettingReference;
import com.mypurecloud.sdk.v2.model.MailFromResult;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class InboundDomainCreateRequest
implements Serializable {
    private String id = null;
    private Boolean subDomain = null;
    private MailFromResult mailFromSettings = null;
    private DomainEntityRef customSMTPServer = null;
    private EmailSettingReference emailSetting = null;

    public InboundDomainCreateRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public InboundDomainCreateRequest id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Unique Id of the domain such as: example.com")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public InboundDomainCreateRequest subDomain(Boolean subDomain) {
        this.subDomain = subDomain;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if this a PureCloud sub-domain. If true, then the appropriate DNS records are created for sending/receiving email.")
    @JsonProperty(value="subDomain")
    public Boolean getSubDomain() {
        return this.subDomain;
    }

    public void setSubDomain(Boolean subDomain) {
        this.subDomain = subDomain;
    }

    public InboundDomainCreateRequest mailFromSettings(MailFromResult mailFromSettings) {
        this.mailFromSettings = mailFromSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="The DNS settings if the inbound domain is using a custom Mail From. These settings can only be used on InboundDomains where subDomain is false.")
    @JsonProperty(value="mailFromSettings")
    public MailFromResult getMailFromSettings() {
        return this.mailFromSettings;
    }

    public void setMailFromSettings(MailFromResult mailFromSettings) {
        this.mailFromSettings = mailFromSettings;
    }

    public InboundDomainCreateRequest customSMTPServer(DomainEntityRef customSMTPServer) {
        this.customSMTPServer = customSMTPServer;
        return this;
    }

    @ApiModelProperty(example="null", value="The custom SMTP server integration to use when sending outbound emails from this domain.")
    @JsonProperty(value="customSMTPServer")
    public DomainEntityRef getCustomSMTPServer() {
        return this.customSMTPServer;
    }

    public void setCustomSMTPServer(DomainEntityRef customSMTPServer) {
        this.customSMTPServer = customSMTPServer;
    }

    public InboundDomainCreateRequest emailSetting(EmailSettingReference emailSetting) {
        this.emailSetting = emailSetting;
        return this;
    }

    @ApiModelProperty(example="null", value="The email settings to associate with this domain.")
    @JsonProperty(value="emailSetting")
    public EmailSettingReference getEmailSetting() {
        return this.emailSetting;
    }

    public void setEmailSetting(EmailSettingReference emailSetting) {
        this.emailSetting = emailSetting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundDomainCreateRequest inboundDomainCreateRequest = (InboundDomainCreateRequest)o;
        return Objects.equals(this.id, inboundDomainCreateRequest.id) && Objects.equals(this.subDomain, inboundDomainCreateRequest.subDomain) && Objects.equals(this.mailFromSettings, inboundDomainCreateRequest.mailFromSettings) && Objects.equals(this.customSMTPServer, inboundDomainCreateRequest.customSMTPServer) && Objects.equals(this.emailSetting, inboundDomainCreateRequest.emailSetting);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.subDomain, this.mailFromSettings, this.customSMTPServer, this.emailSetting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundDomainCreateRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    subDomain: ").append(this.toIndentedString(this.subDomain)).append("\n");
        sb.append("    mailFromSettings: ").append(this.toIndentedString(this.mailFromSettings)).append("\n");
        sb.append("    customSMTPServer: ").append(this.toIndentedString(this.customSMTPServer)).append("\n");
        sb.append("    emailSetting: ").append(this.toIndentedString(this.emailSetting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

