/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.FormDatePicker;
import com.mypurecloud.sdk.v2.model.FormListPicker;
import com.mypurecloud.sdk.v2.model.Input;
import com.mypurecloud.sdk.v2.model.WheelPicker;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="A component within a form page")
public class FormPageComponent
implements Serializable {
    private FormComponentTypeEnum formComponentType = null;
    private FormListPicker listPicker = null;
    private FormDatePicker datePicker = null;
    private Input input = null;
    private WheelPicker wheelPicker = null;

    public FormPageComponent() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public FormPageComponent formComponentType(FormComponentTypeEnum formComponentType) {
        this.formComponentType = formComponentType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of the component")
    @JsonProperty(value="formComponentType")
    public FormComponentTypeEnum getFormComponentType() {
        return this.formComponentType;
    }

    public void setFormComponentType(FormComponentTypeEnum formComponentType) {
        this.formComponentType = formComponentType;
    }

    public FormPageComponent listPicker(FormListPicker listPicker) {
        this.listPicker = listPicker;
        return this;
    }

    @ApiModelProperty(example="null", value="List picker configuration")
    @JsonProperty(value="listPicker")
    public FormListPicker getListPicker() {
        return this.listPicker;
    }

    public void setListPicker(FormListPicker listPicker) {
        this.listPicker = listPicker;
    }

    public FormPageComponent datePicker(FormDatePicker datePicker) {
        this.datePicker = datePicker;
        return this;
    }

    @ApiModelProperty(example="null", value="Date picker configuration")
    @JsonProperty(value="datePicker")
    public FormDatePicker getDatePicker() {
        return this.datePicker;
    }

    public void setDatePicker(FormDatePicker datePicker) {
        this.datePicker = datePicker;
    }

    public FormPageComponent input(Input input) {
        this.input = input;
        return this;
    }

    @ApiModelProperty(example="null", value="Input field configuration")
    @JsonProperty(value="input")
    public Input getInput() {
        return this.input;
    }

    public void setInput(Input input) {
        this.input = input;
    }

    public FormPageComponent wheelPicker(WheelPicker wheelPicker) {
        this.wheelPicker = wheelPicker;
        return this;
    }

    @ApiModelProperty(example="null", value="Wheel picker configuration")
    @JsonProperty(value="wheelPicker")
    public WheelPicker getWheelPicker() {
        return this.wheelPicker;
    }

    public void setWheelPicker(WheelPicker wheelPicker) {
        this.wheelPicker = wheelPicker;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormPageComponent formPageComponent = (FormPageComponent)o;
        return Objects.equals((Object)this.formComponentType, (Object)formPageComponent.formComponentType) && Objects.equals(this.listPicker, formPageComponent.listPicker) && Objects.equals(this.datePicker, formPageComponent.datePicker) && Objects.equals(this.input, formPageComponent.input) && Objects.equals(this.wheelPicker, formPageComponent.wheelPicker);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.formComponentType, this.listPicker, this.datePicker, this.input, this.wheelPicker});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormPageComponent {\n");
        sb.append("    formComponentType: ").append(this.toIndentedString((Object)this.formComponentType)).append("\n");
        sb.append("    listPicker: ").append(this.toIndentedString(this.listPicker)).append("\n");
        sb.append("    datePicker: ").append(this.toIndentedString(this.datePicker)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    wheelPicker: ").append(this.toIndentedString(this.wheelPicker)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FormComponentTypeEnumDeserializer.class)
    public static enum FormComponentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        LISTPICKER("ListPicker"),
        DATEPICKER("DatePicker"),
        INPUT("Input"),
        WHEELPICKER("WheelPicker");

        private String value;

        private FormComponentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FormComponentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FormComponentTypeEnum value : FormComponentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FormComponentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FormComponentTypeEnumDeserializer
    extends StdDeserializer<FormComponentTypeEnum> {
        public FormComponentTypeEnumDeserializer() {
            super(FormComponentTypeEnumDeserializer.class);
        }

        public FormComponentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FormComponentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

