/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ContentOffer;
import com.mypurecloud.sdk.v2.model.OpenActionProperties;
import com.mypurecloud.sdk.v2.model.WebMessagingOfferProperties;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class DeploymentWebAction
implements Serializable {
    private String id = null;
    private MediaTypeEnum mediaType = null;
    private String customerId = null;
    private String customerIdType = null;
    private String actionMapId = null;
    private Integer actionMapVersion = null;
    private String sessionId = null;
    private WebMessagingOfferProperties webMessagingOfferProperties = null;
    private ContentOffer contentOfferProperties = null;
    private OpenActionProperties openActionProperties = null;

    public DeploymentWebAction() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public DeploymentWebAction id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="System-generated UUID for the action.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DeploymentWebAction mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Action media type used to deliver the action.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public DeploymentWebAction customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID string of the customer that the action was triggered for.")
    @JsonProperty(value="customerId")
    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public DeploymentWebAction customerIdType(String customerIdType) {
        this.customerIdType = customerIdType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the customer ID that the action was triggered for.")
    @JsonProperty(value="customerIdType")
    public String getCustomerIdType() {
        return this.customerIdType;
    }

    public void setCustomerIdType(String customerIdType) {
        this.customerIdType = customerIdType;
    }

    public DeploymentWebAction actionMapId(String actionMapId) {
        this.actionMapId = actionMapId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the action map that triggered the action.")
    @JsonProperty(value="actionMapId")
    public String getActionMapId() {
        return this.actionMapId;
    }

    public void setActionMapId(String actionMapId) {
        this.actionMapId = actionMapId;
    }

    public DeploymentWebAction actionMapVersion(Integer actionMapVersion) {
        this.actionMapVersion = actionMapVersion;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version of the action map that triggered the action.")
    @JsonProperty(value="actionMapVersion")
    public Integer getActionMapVersion() {
        return this.actionMapVersion;
    }

    public void setActionMapVersion(Integer actionMapVersion) {
        this.actionMapVersion = actionMapVersion;
    }

    public DeploymentWebAction sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the session that the action was triggered for.")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public DeploymentWebAction webMessagingOfferProperties(WebMessagingOfferProperties webMessagingOfferProperties) {
        this.webMessagingOfferProperties = webMessagingOfferProperties;
        return this;
    }

    @ApiModelProperty(example="null", value="Web messaging offer specific properties.")
    @JsonProperty(value="webMessagingOfferProperties")
    public WebMessagingOfferProperties getWebMessagingOfferProperties() {
        return this.webMessagingOfferProperties;
    }

    public void setWebMessagingOfferProperties(WebMessagingOfferProperties webMessagingOfferProperties) {
        this.webMessagingOfferProperties = webMessagingOfferProperties;
    }

    public DeploymentWebAction contentOfferProperties(ContentOffer contentOfferProperties) {
        this.contentOfferProperties = contentOfferProperties;
        return this;
    }

    @ApiModelProperty(example="null", value="Content offer specific properties.")
    @JsonProperty(value="contentOfferProperties")
    public ContentOffer getContentOfferProperties() {
        return this.contentOfferProperties;
    }

    public void setContentOfferProperties(ContentOffer contentOfferProperties) {
        this.contentOfferProperties = contentOfferProperties;
    }

    public DeploymentWebAction openActionProperties(OpenActionProperties openActionProperties) {
        this.openActionProperties = openActionProperties;
        return this;
    }

    @ApiModelProperty(example="null", value="Open action specific properties.")
    @JsonProperty(value="openActionProperties")
    public OpenActionProperties getOpenActionProperties() {
        return this.openActionProperties;
    }

    public void setOpenActionProperties(OpenActionProperties openActionProperties) {
        this.openActionProperties = openActionProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentWebAction deploymentWebAction = (DeploymentWebAction)o;
        return Objects.equals(this.id, deploymentWebAction.id) && Objects.equals((Object)this.mediaType, (Object)deploymentWebAction.mediaType) && Objects.equals(this.customerId, deploymentWebAction.customerId) && Objects.equals(this.customerIdType, deploymentWebAction.customerIdType) && Objects.equals(this.actionMapId, deploymentWebAction.actionMapId) && Objects.equals(this.actionMapVersion, deploymentWebAction.actionMapVersion) && Objects.equals(this.sessionId, deploymentWebAction.sessionId) && Objects.equals(this.webMessagingOfferProperties, deploymentWebAction.webMessagingOfferProperties) && Objects.equals(this.contentOfferProperties, deploymentWebAction.contentOfferProperties) && Objects.equals(this.openActionProperties, deploymentWebAction.openActionProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.mediaType, this.customerId, this.customerIdType, this.actionMapId, this.actionMapVersion, this.sessionId, this.webMessagingOfferProperties, this.contentOfferProperties, this.openActionProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeploymentWebAction {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    customerIdType: ").append(this.toIndentedString(this.customerIdType)).append("\n");
        sb.append("    actionMapId: ").append(this.toIndentedString(this.actionMapId)).append("\n");
        sb.append("    actionMapVersion: ").append(this.toIndentedString(this.actionMapVersion)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    webMessagingOfferProperties: ").append(this.toIndentedString(this.webMessagingOfferProperties)).append("\n");
        sb.append("    contentOfferProperties: ").append(this.toIndentedString(this.contentOfferProperties)).append("\n");
        sb.append("    openActionProperties: ").append(this.toIndentedString(this.openActionProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WEBCHAT("webchat"),
        WEBMESSAGINGOFFER("webMessagingOffer"),
        CONTENTOFFER("contentOffer"),
        INTEGRATIONACTION("integrationAction"),
        ARCHITECTFLOW("architectFlow"),
        OPENACTION("openAction");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

