/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.WrapUpCodeConfig;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class CreateKpiRequest
implements Serializable {
    private String name = null;
    private String description = null;
    private KpiTypeEnum kpiType = null;
    private WrapUpCodeConfig wrapUpCodeConfig = null;
    private SourceEnum source = null;

    public CreateKpiRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public CreateKpiRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Key Performance Indicator.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateKpiRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the Key Performance Indicator.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateKpiRequest kpiType(KpiTypeEnum kpiType) {
        this.kpiType = kpiType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of the Key Performance Indicator.")
    @JsonProperty(value="kpiType")
    public KpiTypeEnum getKpiType() {
        return this.kpiType;
    }

    public void setKpiType(KpiTypeEnum kpiType) {
        this.kpiType = kpiType;
    }

    public CreateKpiRequest wrapUpCodeConfig(WrapUpCodeConfig wrapUpCodeConfig) {
        this.wrapUpCodeConfig = wrapUpCodeConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines what wrap up codes are mapped to Key Performance Indicator.")
    @JsonProperty(value="wrapUpCodeConfig")
    public WrapUpCodeConfig getWrapUpCodeConfig() {
        return this.wrapUpCodeConfig;
    }

    public void setWrapUpCodeConfig(WrapUpCodeConfig wrapUpCodeConfig) {
        this.wrapUpCodeConfig = wrapUpCodeConfig;
    }

    public CreateKpiRequest source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The source of the Key Performance Indicator.")
    @JsonProperty(value="source")
    public SourceEnum getSource() {
        return this.source;
    }

    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateKpiRequest createKpiRequest = (CreateKpiRequest)o;
        return Objects.equals(this.name, createKpiRequest.name) && Objects.equals(this.description, createKpiRequest.description) && Objects.equals((Object)this.kpiType, (Object)createKpiRequest.kpiType) && Objects.equals(this.wrapUpCodeConfig, createKpiRequest.wrapUpCodeConfig) && Objects.equals((Object)this.source, (Object)createKpiRequest.source);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.kpiType, this.wrapUpCodeConfig, this.source});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateKpiRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    kpiType: ").append(this.toIndentedString((Object)this.kpiType)).append("\n");
        sb.append("    wrapUpCodeConfig: ").append(this.toIndentedString(this.wrapUpCodeConfig)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=KpiTypeEnumDeserializer.class)
    public static enum KpiTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SALESCONVERSION("SalesConversion"),
        CHURN("Churn"),
        RETENTION("Retention"),
        SALESVALUE("SalesValue");

        private String value;

        private KpiTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static KpiTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (KpiTypeEnum value : KpiTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return KpiTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SourceEnumDeserializer.class)
    public static enum SourceEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WRAPUPCODE("WrapUpCode"),
        OUTCOME("Outcome"),
        NONE("None");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SourceEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SourceEnum value : SourceEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SourceEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SourceEnumDeserializer
    extends StdDeserializer<SourceEnum> {
        public SourceEnumDeserializer() {
            super(SourceEnumDeserializer.class);
        }

        public SourceEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SourceEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class KpiTypeEnumDeserializer
    extends StdDeserializer<KpiTypeEnum> {
        public KpiTypeEnumDeserializer() {
            super(KpiTypeEnumDeserializer.class);
        }

        public KpiTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return KpiTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

