/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ChecklistActivationPayload
implements Serializable {
    private ActivationTriggerTypeEnum activationTriggerType = null;
    private String intentId = null;
    private String intentName = null;
    private String language = null;
    private String agentId = null;
    private String participantId = null;
    private String queueId = null;
    private String assistantId = null;
    private MediaTypeEnum mediaType = null;
    private DirectionEnum direction = null;

    public ChecklistActivationPayload() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ChecklistActivationPayload activationTriggerType(ActivationTriggerTypeEnum activationTriggerType) {
        this.activationTriggerType = activationTriggerType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Trigger type that activated this checklist.")
    @JsonProperty(value="activationTriggerType")
    public ActivationTriggerTypeEnum getActivationTriggerType() {
        return this.activationTriggerType;
    }

    public void setActivationTriggerType(ActivationTriggerTypeEnum activationTriggerType) {
        this.activationTriggerType = activationTriggerType;
    }

    public ChecklistActivationPayload intentId(String intentId) {
        this.intentId = intentId;
        return this;
    }

    @ApiModelProperty(example="null", value="The intent ID if checklist was triggered by an intent.")
    @JsonProperty(value="intentId")
    public String getIntentId() {
        return this.intentId;
    }

    public void setIntentId(String intentId) {
        this.intentId = intentId;
    }

    public ChecklistActivationPayload intentName(String intentName) {
        this.intentName = intentName;
        return this;
    }

    @ApiModelProperty(example="null", value="The intent name if checklist was triggered by an intent.")
    @JsonProperty(value="intentName")
    public String getIntentName() {
        return this.intentName;
    }

    public void setIntentName(String intentName) {
        this.intentName = intentName;
    }

    public ChecklistActivationPayload language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Language associated with the checklist.")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public ChecklistActivationPayload agentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    @ApiModelProperty(example="null", value="Agent ID.")
    @JsonProperty(value="agentId")
    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public ChecklistActivationPayload participantId(String participantId) {
        this.participantId = participantId;
        return this;
    }

    @ApiModelProperty(example="null", value="Participant ID.")
    @JsonProperty(value="participantId")
    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public ChecklistActivationPayload queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="Queue ID.")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public ChecklistActivationPayload assistantId(String assistantId) {
        this.assistantId = assistantId;
        return this;
    }

    @ApiModelProperty(example="null", value="Assistant ID.")
    @JsonProperty(value="assistantId")
    public String getAssistantId() {
        return this.assistantId;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public ChecklistActivationPayload mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="Media type.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public ChecklistActivationPayload direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="Direction of the conversation.")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChecklistActivationPayload checklistActivationPayload = (ChecklistActivationPayload)o;
        return Objects.equals((Object)this.activationTriggerType, (Object)checklistActivationPayload.activationTriggerType) && Objects.equals(this.intentId, checklistActivationPayload.intentId) && Objects.equals(this.intentName, checklistActivationPayload.intentName) && Objects.equals(this.language, checklistActivationPayload.language) && Objects.equals(this.agentId, checklistActivationPayload.agentId) && Objects.equals(this.participantId, checklistActivationPayload.participantId) && Objects.equals(this.queueId, checklistActivationPayload.queueId) && Objects.equals(this.assistantId, checklistActivationPayload.assistantId) && Objects.equals((Object)this.mediaType, (Object)checklistActivationPayload.mediaType) && Objects.equals((Object)this.direction, (Object)checklistActivationPayload.direction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activationTriggerType, this.intentId, this.intentName, this.language, this.agentId, this.participantId, this.queueId, this.assistantId, this.mediaType, this.direction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChecklistActivationPayload {\n");
        sb.append("    activationTriggerType: ").append(this.toIndentedString((Object)this.activationTriggerType)).append("\n");
        sb.append("    intentId: ").append(this.toIndentedString(this.intentId)).append("\n");
        sb.append("    intentName: ").append(this.toIndentedString(this.intentName)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    agentId: ").append(this.toIndentedString(this.agentId)).append("\n");
        sb.append("    participantId: ").append(this.toIndentedString(this.participantId)).append("\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    assistantId: ").append(this.toIndentedString(this.assistantId)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActivationTriggerTypeEnumDeserializer.class)
    public static enum ActivationTriggerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INTENT("Intent"),
        CONVERSATIONSTART("ConversationStart");

        private String value;

        private ActivationTriggerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActivationTriggerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActivationTriggerTypeEnum value : ActivationTriggerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActivationTriggerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VOICE("Voice"),
        MESSAGE("Message"),
        EMAIL("Email");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("Inbound"),
        OUTBOUND("Outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ActivationTriggerTypeEnumDeserializer
    extends StdDeserializer<ActivationTriggerTypeEnum> {
        public ActivationTriggerTypeEnumDeserializer() {
            super(ActivationTriggerTypeEnumDeserializer.class);
        }

        public ActivationTriggerTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActivationTriggerTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

