/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.DynamicLineBalancingSettingsPatchRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Campaign patch request")
public class CampaignPatchRequest
implements Serializable {
    private Integer outboundLineCount = null;
    private BigDecimal abandonRate = null;
    private BigDecimal maxCallsPerAgent = null;
    private DynamicLineBalancingSettingsPatchRequest dynamicLineBalancingSettings = null;
    private AddressableEntityRef queue = null;

    public CampaignPatchRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public CampaignPatchRequest outboundLineCount(Integer outboundLineCount) {
        this.outboundLineCount = outboundLineCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of outbound lines to be concurrently dialed.")
    @JsonProperty(value="outboundLineCount")
    public Integer getOutboundLineCount() {
        return this.outboundLineCount;
    }

    public void setOutboundLineCount(Integer outboundLineCount) {
        this.outboundLineCount = outboundLineCount;
    }

    public CampaignPatchRequest abandonRate(BigDecimal abandonRate) {
        this.abandonRate = abandonRate;
        return this;
    }

    @ApiModelProperty(example="null", value="The targeted compliance abandon rate percentage")
    @JsonProperty(value="abandonRate")
    public BigDecimal getAbandonRate() {
        return this.abandonRate;
    }

    public void setAbandonRate(BigDecimal abandonRate) {
        this.abandonRate = abandonRate;
    }

    public CampaignPatchRequest maxCallsPerAgent(BigDecimal maxCallsPerAgent) {
        this.maxCallsPerAgent = maxCallsPerAgent;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum number of calls that can be placed per agent on this campaign")
    @JsonProperty(value="maxCallsPerAgent")
    public BigDecimal getMaxCallsPerAgent() {
        return this.maxCallsPerAgent;
    }

    public void setMaxCallsPerAgent(BigDecimal maxCallsPerAgent) {
        this.maxCallsPerAgent = maxCallsPerAgent;
    }

    public CampaignPatchRequest dynamicLineBalancingSettings(DynamicLineBalancingSettingsPatchRequest dynamicLineBalancingSettings) {
        this.dynamicLineBalancingSettings = dynamicLineBalancingSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Dynamic line balancing settings")
    @JsonProperty(value="dynamicLineBalancingSettings")
    public DynamicLineBalancingSettingsPatchRequest getDynamicLineBalancingSettings() {
        return this.dynamicLineBalancingSettings;
    }

    public void setDynamicLineBalancingSettings(DynamicLineBalancingSettingsPatchRequest dynamicLineBalancingSettings) {
        this.dynamicLineBalancingSettings = dynamicLineBalancingSettings;
    }

    public CampaignPatchRequest queue(AddressableEntityRef queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The Queue for this Campaign to route calls to.")
    @JsonProperty(value="queue")
    public AddressableEntityRef getQueue() {
        return this.queue;
    }

    public void setQueue(AddressableEntityRef queue) {
        this.queue = queue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignPatchRequest campaignPatchRequest = (CampaignPatchRequest)o;
        return Objects.equals(this.outboundLineCount, campaignPatchRequest.outboundLineCount) && Objects.equals(this.abandonRate, campaignPatchRequest.abandonRate) && Objects.equals(this.maxCallsPerAgent, campaignPatchRequest.maxCallsPerAgent) && Objects.equals(this.dynamicLineBalancingSettings, campaignPatchRequest.dynamicLineBalancingSettings) && Objects.equals(this.queue, campaignPatchRequest.queue);
    }

    public int hashCode() {
        return Objects.hash(this.outboundLineCount, this.abandonRate, this.maxCallsPerAgent, this.dynamicLineBalancingSettings, this.queue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CampaignPatchRequest {\n");
        sb.append("    outboundLineCount: ").append(this.toIndentedString(this.outboundLineCount)).append("\n");
        sb.append("    abandonRate: ").append(this.toIndentedString(this.abandonRate)).append("\n");
        sb.append("    maxCallsPerAgent: ").append(this.toIndentedString(this.maxCallsPerAgent)).append("\n");
        sb.append("    dynamicLineBalancingSettings: ").append(this.toIndentedString(this.dynamicLineBalancingSettings)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

