/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AgentChecklistItem;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AgentChecklist
implements Serializable {
    private String id = null;
    private String name = null;
    private String language = null;
    private List<AgentChecklistItem> checklistItems = null;
    private UserReference createdBy = null;
    private UserReference modifiedBy = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String selfUri = null;

    public AgentChecklist() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.checklistItems = new ArrayList<AgentChecklistItem>();
        }
    }

    @ApiModelProperty(example="null", value="Agent Checklist ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public AgentChecklist name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Agent Checklist Name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AgentChecklist language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Agent Checklist Language.")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public AgentChecklist checklistItems(List<AgentChecklistItem> checklistItems) {
        this.checklistItems = checklistItems;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Agent Checklist Items.")
    @JsonProperty(value="checklistItems")
    public List<AgentChecklistItem> getChecklistItems() {
        return this.checklistItems;
    }

    public void setChecklistItems(List<AgentChecklistItem> checklistItems) {
        this.checklistItems = checklistItems;
    }

    @ApiModelProperty(example="null", value="The user who created the agent checklist.")
    @JsonProperty(value="createdBy")
    public UserReference getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(example="null", value="The user who last modified the agent checklist.")
    @JsonProperty(value="modifiedBy")
    public UserReference getModifiedBy() {
        return this.modifiedBy;
    }

    @ApiModelProperty(example="null", value="Date when the agent checklist was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Date when the agent checklist was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentChecklist agentChecklist = (AgentChecklist)o;
        return Objects.equals(this.id, agentChecklist.id) && Objects.equals(this.name, agentChecklist.name) && Objects.equals(this.language, agentChecklist.language) && Objects.equals(this.checklistItems, agentChecklist.checklistItems) && Objects.equals(this.createdBy, agentChecklist.createdBy) && Objects.equals(this.modifiedBy, agentChecklist.modifiedBy) && Objects.equals(this.dateCreated, agentChecklist.dateCreated) && Objects.equals(this.dateModified, agentChecklist.dateModified) && Objects.equals(this.selfUri, agentChecklist.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.language, this.checklistItems, this.createdBy, this.modifiedBy, this.dateCreated, this.dateModified, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentChecklist {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    checklistItems: ").append(this.toIndentedString(this.checklistItems)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

